/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.remoting.AsyncMethodNotificationHandler;
import org.jboss.ejb.client.remoting.ClusterNodeRemovalHandler;
import org.jboss.ejb.client.remoting.ClusterRemovalMessageHandler;
import org.jboss.ejb.client.remoting.ClusterTopologyMessageHandler;
import org.jboss.ejb.client.remoting.CompressedMessageHandler;
import org.jboss.ejb.client.remoting.GeneralInvocationFailureResponseHandler;
import org.jboss.ejb.client.remoting.InvocationExceptionResponseHandler;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.MethodInvocationResponseHandler;
import org.jboss.ejb.client.remoting.ModuleAvailabilityMessageHandler;
import org.jboss.ejb.client.remoting.NoSuchEJBExceptionResponseHandler;
import org.jboss.ejb.client.remoting.NonStatefulBeanSessionOpenFailureHandler;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.ejb.client.remoting.SessionOpenResponseHandler;
import org.jboss.ejb.client.remoting.TransactionInvocationResponseHandler;
import org.jboss.ejb.client.remoting.TransactionRecoveryResponseHandler;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.FutureResult;

class ChannelAssociation {
    private static final Logger logger = Logger.getLogger(ChannelAssociation.class);
    private final RemotingConnectionEJBReceiver ejbReceiver;
    private final EJBReceiverContext ejbReceiverContext;
    private final Channel channel;
    private final byte protocolVersion;
    private final MarshallerFactory marshallerFactory;
    private final AtomicInteger nextInvocationId = new AtomicInteger(0);
    private final Map<Short, EJBReceiverInvocationContext> waitingMethodInvocations = Collections.synchronizedMap(new HashMap());
    private final Map<Short, FutureResult<EJBReceiverInvocationContext.ResultProducer>> waitingFutureResults = Collections.synchronizedMap(new HashMap());
    private final ReconnectHandler reconnectHandler;
    private final Semaphore channelWriteSemaphore;
    private final Map<EJBReceiverInvocationContext, Short> invocationIdsPerReceiverInvocationCtx = Collections.synchronizedMap(new IdentityHashMap());
    private final MessageCompatibilityChecker messageCompatibilityChecker;

    ChannelAssociation(RemotingConnectionEJBReceiver ejbReceiver, EJBReceiverContext ejbReceiverContext, Channel channel, byte protocolVersion, MarshallerFactory marshallerFactory, ReconnectHandler reconnectHandler) {
        this.ejbReceiver = ejbReceiver;
        this.ejbReceiverContext = ejbReceiverContext;
        this.channel = channel;
        this.protocolVersion = protocolVersion;
        this.marshallerFactory = marshallerFactory;
        this.reconnectHandler = reconnectHandler;
        this.channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                logger.debug((Object)("Closing channel " + closed), (Throwable)exception);
                if (exception != null) {
                    ChannelAssociation.this.notifyBrokenChannel(exception);
                } else {
                    ChannelAssociation.this.notifyBrokenChannel(new IOException("Channel " + closed + " has been closed"));
                }
            }
        });
        this.channel.receiveMessage((Channel.Receiver)new ResponseReceiver());
        Integer maxOutboundWrites = (Integer)this.channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES);
        if (maxOutboundWrites == null) {
            maxOutboundWrites = 80;
        }
        this.channelWriteSemaphore = new Semaphore(maxOutboundWrites, true);
        switch (protocolVersion) {
            case 1: {
                this.messageCompatibilityChecker = new ProtocolVersionOneMessageCompatibilityChecker();
                break;
            }
            case 2: {
                this.messageCompatibilityChecker = new ProtocolVersionTwoMessageCompatibilityChecker();
                break;
            }
            default: {
                this.messageCompatibilityChecker = null;
            }
        }
    }

    Channel getChannel() {
        return this.channel;
    }

    EJBReceiverContext getEjbReceiverContext() {
        return this.ejbReceiverContext;
    }

    short getNextInvocationId() {
        return (short)this.nextInvocationId.getAndIncrement();
    }

    void receiveResponse(short invocationId, EJBReceiverInvocationContext ejbReceiverInvocationContext) {
        this.waitingMethodInvocations.put(invocationId, ejbReceiverInvocationContext);
        this.invocationIdsPerReceiverInvocationCtx.put(ejbReceiverInvocationContext, invocationId);
    }

    Future<EJBReceiverInvocationContext.ResultProducer> enrollForResult(short invocationId) {
        FutureResult futureResult = new FutureResult();
        this.waitingFutureResults.put(invocationId, (FutureResult<EJBReceiverInvocationContext.ResultProducer>)futureResult);
        return IoFutureHelper.future(futureResult.getIoFuture());
    }

    void resultReady(short invocationId, EJBReceiverInvocationContext.ResultProducer resultProducer) {
        if (this.waitingMethodInvocations.containsKey(invocationId)) {
            EJBReceiverInvocationContext ejbReceiverInvocationContext = this.waitingMethodInvocations.remove(invocationId);
            if (ejbReceiverInvocationContext != null) {
                this.invocationIdsPerReceiverInvocationCtx.remove(ejbReceiverInvocationContext);
                ejbReceiverInvocationContext.resultReady(resultProducer);
            }
        } else if (this.waitingFutureResults.containsKey(invocationId)) {
            FutureResult<EJBReceiverInvocationContext.ResultProducer> future = this.waitingFutureResults.remove(invocationId);
            if (future != null) {
                future.setResult((Object)resultProducer);
            }
        } else {
            Logs.REMOTING.discardingInvocationResult(invocationId);
        }
    }

    void handleAsyncMethodNotification(short invocationId) {
        EJBReceiverInvocationContext receiverInvocationContext = this.waitingMethodInvocations.get(invocationId);
        if (receiverInvocationContext == null) {
            logger.debug((Object)("No waiting context found for async method invocation with id " + invocationId));
            return;
        }
        receiverInvocationContext.proceedAsynchronously();
    }

    EJBReceiverInvocationContext getEJBReceiverInvocationContext(short invocationId) {
        return this.waitingMethodInvocations.get(invocationId);
    }

    MessageOutputStream acquireChannelMessageOutputStream() throws Exception {
        this.channelWriteSemaphore.acquire();
        try {
            return this.channel.writeMessage();
        }
        catch (Exception e) {
            this.channelWriteSemaphore.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseChannelMessageOutputStream(MessageOutputStream messageOutputStream) throws IOException {
        try {
            messageOutputStream.close();
        }
        finally {
            this.channelWriteSemaphore.release();
        }
    }

    Short getInvocationId(EJBReceiverInvocationContext ejbReceiverInvocationContext) {
        return this.invocationIdsPerReceiverInvocationCtx.get(ejbReceiverInvocationContext);
    }

    private ProtocolMessageHandler getProtocolMessageHandler(byte header) {
        switch (header) {
            case 2: {
                return new SessionOpenResponseHandler(this, this.marshallerFactory);
            }
            case 5: {
                return new MethodInvocationResponseHandler(this, this.marshallerFactory);
            }
            case 6: {
                return new InvocationExceptionResponseHandler(this, this.marshallerFactory);
            }
            case 8: {
                return new ModuleAvailabilityMessageHandler(this.ejbReceiver, this.ejbReceiverContext, ModuleAvailabilityMessageHandler.ModuleReportType.MODULE_AVAILABLE);
            }
            case 9: {
                return new ModuleAvailabilityMessageHandler(this.ejbReceiver, this.ejbReceiverContext, ModuleAvailabilityMessageHandler.ModuleReportType.MODULE_UNAVAILABLE);
            }
            case 10: {
                return new NoSuchEJBExceptionResponseHandler(this);
            }
            case 11: {
                return new GeneralInvocationFailureResponseHandler(this, GeneralInvocationFailureResponseHandler.FailureType.NO_SUCH_METHOD);
            }
            case 12: {
                return new GeneralInvocationFailureResponseHandler(this, GeneralInvocationFailureResponseHandler.FailureType.SESSION_NOT_ACTIVE);
            }
            case 13: {
                return new NonStatefulBeanSessionOpenFailureHandler(this);
            }
            case 14: {
                return new AsyncMethodNotificationHandler(this);
            }
            case 20: {
                return new TransactionInvocationResponseHandler(this);
            }
            case 21: {
                return new ClusterTopologyMessageHandler(this, true);
            }
            case 22: {
                return new ClusterRemovalMessageHandler(this.ejbReceiverContext);
            }
            case 23: {
                return new ClusterTopologyMessageHandler(this, false);
            }
            case 24: {
                return new ClusterNodeRemovalHandler(this);
            }
            case 26: {
                return new TransactionRecoveryResponseHandler(this, this.marshallerFactory);
            }
            case 27: {
                return new CompressedMessageHandler(this);
            }
        }
        return null;
    }

    void processResponse(InputStream inputStream) throws IOException {
        ProtocolMessageHandler messageHandler;
        int header = inputStream.read();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received message with header 0x" + Integer.toHexString(header)));
        }
        if ((messageHandler = this.getProtocolMessageHandler((byte)header)) == null) {
            logger.debug((Object)("Unsupported message received with header 0x" + Integer.toHexString(header)));
            return;
        }
        messageHandler.processMessage(inputStream);
    }

    boolean isMessageCompatibleForNegotiatedProtocolVersion(byte messageHeader) {
        if (this.messageCompatibilityChecker == null) {
            return false;
        }
        return this.messageCompatibilityChecker.isMessageCompatible(messageHeader);
    }

    byte getNegotiatedProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBrokenChannel(IOException ioException) {
        if (ioException == null) {
            throw new IllegalArgumentException("Exception cannot be null");
        }
        try {
            UnusableChannelResultProducer unusableChannelResultProducer = new UnusableChannelResultProducer(ioException);
            Collection<EJBReceiverInvocationContext> receiverInvocationContexts = this.waitingMethodInvocations.values();
            Map<Short, EJBReceiverInvocationContext> map = this.waitingMethodInvocations;
            synchronized (map) {
                for (EJBReceiverInvocationContext receiverInvocationContext : receiverInvocationContexts) {
                    receiverInvocationContext.resultReady(unusableChannelResultProducer);
                }
            }
            Collection<FutureResult<EJBReceiverInvocationContext.ResultProducer>> futureResults = this.waitingFutureResults.values();
            Map<Short, FutureResult<EJBReceiverInvocationContext.ResultProducer>> map2 = this.waitingFutureResults;
            synchronized (map2) {
                for (FutureResult<EJBReceiverInvocationContext.ResultProducer> resultProducerFutureResult : futureResults) {
                    resultProducerFutureResult.setResult((Object)unusableChannelResultProducer);
                }
            }
        }
        finally {
            this.ejbReceiverContext.close();
            if (this.reconnectHandler != null) {
                EJBClientContext ejbClientContext = this.ejbReceiverContext.getClientContext();
                logger.debug((Object)("Registering a re-connect handler " + this.reconnectHandler + " for broken channel " + this.channel + " in EJB client context " + ejbClientContext));
                ejbClientContext.registerReconnectHandler(this.reconnectHandler);
            }
        }
    }

    private class ProtocolVersionTwoMessageCompatibilityChecker
    extends ProtocolVersionOneMessageCompatibilityChecker {
        private ProtocolVersionTwoMessageCompatibilityChecker() {
        }

        @Override
        public boolean isMessageCompatible(byte messageHeader) {
            switch (messageHeader) {
                case 25: 
                case 27: {
                    return true;
                }
            }
            return super.isMessageCompatible(messageHeader);
        }
    }

    private class ProtocolVersionOneMessageCompatibilityChecker
    implements MessageCompatibilityChecker {
        private ProtocolVersionOneMessageCompatibilityChecker() {
        }

        @Override
        public boolean isMessageCompatible(byte messageHeader) {
            switch (messageHeader) {
                case 1: 
                case 3: 
                case 4: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
    }

    private static interface MessageCompatibilityChecker {
        public boolean isMessageCompatible(byte var1);
    }

    private class UnusableChannelResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final IOException ioException;

        UnusableChannelResultProducer(IOException ioexception) {
            this.ioException = ioexception;
        }

        @Override
        public Object getResult() throws Exception {
            throw this.ioException;
        }

        @Override
        public void discardResult() {
        }
    }

    private class ResponseReceiver
    implements Channel.Receiver {
        private ResponseReceiver() {
        }

        public void handleError(Channel channel, IOException error) {
            logger.error((Object)("Error on channel " + channel), (Throwable)error);
            try {
                channel.close();
            }
            catch (IOException ioe) {
                if (error != null) {
                    ChannelAssociation.this.notifyBrokenChannel(error);
                }
                ChannelAssociation.this.notifyBrokenChannel(new IOException("Channel " + channel + " received error notification"));
            }
        }

        public void handleEnd(Channel channel) {
            Logs.REMOTING.channelCanNoLongerProcessMessages(channel);
            try {
                channel.close();
            }
            catch (IOException ioe) {
                ChannelAssociation.this.notifyBrokenChannel(new IOException("Channel " + channel + " is no longer readable"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            try {
                ChannelAssociation.this.processResponse((InputStream)messageInputStream);
            }
            catch (IOException e) {
                this.handleError(channel, e);
            }
            finally {
                channel.receiveMessage((Channel.Receiver)this);
            }
        }
    }
}

