/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository;

import java.util.Map;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;

public final class XRequirementBuilder {
    private final XResourceBuilder<XResource> builder;
    private final XRequirement requirement;

    public static XRequirementBuilder create(ModuleIdentifier moduleId) {
        return XRequirementBuilder.create("module.identity", moduleId.toString());
    }

    public static XRequirementBuilder create(MavenCoordinates coordinates) {
        return XRequirementBuilder.create("maven.identity", coordinates.toExternalForm());
    }

    public static XRequirementBuilder create(String namespace) {
        return XRequirementBuilder.create(namespace, null);
    }

    public static XRequirementBuilder create(String namespace, String nsvalue) {
        XResourceBuilder builder = XResourceBuilderFactory.create();
        XRequirement req = builder.addRequirement(namespace, nsvalue);
        return new XRequirementBuilder((XResourceBuilder<XResource>)builder, req);
    }

    private XRequirementBuilder(XResourceBuilder<XResource> builder, XRequirement requirement) {
        this.builder = builder;
        this.requirement = requirement;
    }

    public Map<String, Object> getAttributes() {
        return this.requirement.getAttributes();
    }

    public Map<String, String> getDirectives() {
        return this.requirement.getDirectives();
    }

    public XRequirement getRequirement() {
        XResource resource = this.builder.getResource();
        String namespace = this.requirement.getNamespace();
        return (XRequirement)resource.getRequirements(namespace).get(0);
    }
}

