/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.spi;

import java.util.HashMap;
import java.util.Map;
import org.jboss.osgi.repository.XContentCapability;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractCapability;

public class AbstractRepositoryCapability
extends AbstractCapability
implements XContentCapability {
    private String mimeType;
    private String digest;
    private String contentURL;
    private Long size;

    public AbstractRepositoryCapability(XResource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        super(resource, namespace, AbstractRepositoryCapability.replaceAttributeTypes(atts), dirs);
    }

    private static Map<String, Object> replaceAttributeTypes(Map<String, Object> atts) {
        HashMap<String, Object> result = new HashMap<String, Object>(atts);
        Object val = result.get("size");
        if (val instanceof String) {
            result.put("size", Long.parseLong((String)val));
        }
        return result;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public String getContentURL() {
        return this.contentURL;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public void validate() {
        super.validate();
        if ("osgi.content".equals(this.getNamespace())) {
            this.digest = (String)this.getAttribute("osgi.content");
            if (this.digest == null) {
                throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute("osgi.content");
            }
            this.mimeType = (String)this.getAttribute("mime");
            if (this.mimeType == null) {
                throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute("mime");
            }
            this.mimeType = (String)this.getAttribute("mime");
            if (this.mimeType == null) {
                throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute("mime");
            }
            this.contentURL = (String)this.getAttribute("url");
            if (this.contentURL == null) {
                throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute("url");
            }
            this.size = (Long)this.getAttribute("size");
            if (this.size == null) {
                throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute("size");
            }
        }
    }

    public <T extends XCapability> T adapt(Class<T> clazz) {
        XCapability result = super.adapt(clazz);
        if (result == null && XContentCapability.class == clazz && "osgi.content".equals(this.getNamespace())) {
            result = this;
        }
        return (T)result;
    }
}

