/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.xts.XtsAsMessages;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public final class XTSHandlersManager {
    private static final String CLIENT_CONFIG_TYPE = "client-config";
    private static final String CLIENT_CONFIG_NAME = "Standard-Client-Config";
    private static final String HANDLER_CHAIN_ID = "xts-handler-chain";
    private static final String HANDLER_PROTOCOL_BINDINGS = "##SOAP11_HTTP ##SOAP12_HTTP";
    private static final String WSAT_HANDLER_NAME = "JaxWSHeaderContextProcessor";
    private static final String WSAT_ENABLED_HANDLER_CLASS = "com.arjuna.mw.wst11.client.EnabledWSTXHandler";
    private static final String WSAT_DISABLED_HANDLER_CLASS = "com.arjuna.mw.wst11.client.DisabledWSTXHandler";
    private static final String BRIDGE_HANDLER_NAME = "JaxWSTxOutboundBridgeHandler";
    private static final String BRIDGE_ENABLED_HANDLER_CLASS = "org.jboss.jbossts.txbridge.outbound.EnabledJTAOverWSATHandler";
    private static final String BRIDGE_DISABLED_HANDLER_CLASS = "org.jboss.jbossts.txbridge.outbound.DisabledJTAOverWSATHandler";
    private final ServerConfig serverConfig;

    public XTSHandlersManager(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void registerClientHandlers(boolean isEnabled) {
        if (isEnabled) {
            this.registerEnabledClientHandlers();
        } else {
            this.registerDisabledClientHandlers();
        }
    }

    private void registerEnabledClientHandlers() {
        this.registerClientHandler(BRIDGE_ENABLED_HANDLER_CLASS, BRIDGE_HANDLER_NAME);
        this.registerClientHandler(WSAT_ENABLED_HANDLER_CLASS, WSAT_HANDLER_NAME);
    }

    private void registerDisabledClientHandlers() {
        this.registerClientHandler(BRIDGE_DISABLED_HANDLER_CLASS, BRIDGE_HANDLER_NAME);
        this.registerClientHandler(WSAT_DISABLED_HANDLER_CLASS, WSAT_HANDLER_NAME);
    }

    private void registerClientHandler(String handlerClass, String handlerName) {
        UnifiedHandlerChainMetaData handlerChain = this.getHandlerChain(HANDLER_CHAIN_ID, HANDLER_PROTOCOL_BINDINGS, CLIENT_CONFIG_TYPE, CLIENT_CONFIG_NAME);
        UnifiedHandlerMetaData handler = new UnifiedHandlerMetaData();
        handler.setHandlerName(handlerName);
        handler.setHandlerClass(handlerClass);
        handlerChain.addHandler(handler);
    }

    private UnifiedHandlerChainMetaData getHandlerChain(String handlerChainId, String protocolBindings, String configType, String configName) {
        UnifiedHandlerChainMetaData handlerChain;
        CommonConfig commonConfig = this.getCommonConfig(configType, configName);
        LinkedList<UnifiedHandlerChainMetaData> handlerChains = commonConfig.getPostHandlerChains();
        if (handlerChains == null) {
            handlerChains = new LinkedList<UnifiedHandlerChainMetaData>();
            commonConfig.setPostHandlerChains(handlerChains);
        }
        if ((handlerChain = this.getChain(handlerChains, handlerChainId)) == null) {
            handlerChain = new UnifiedHandlerChainMetaData();
            handlerChain.setId(handlerChainId);
            handlerChain.setProtocolBindings(protocolBindings);
            handlerChains.add(handlerChain);
        }
        return handlerChain;
    }

    private UnifiedHandlerChainMetaData getChain(List<UnifiedHandlerChainMetaData> handlerChains, String handlerChainId) {
        for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
            if (!handlerChainId.equals(handlerChain.getId())) continue;
            return handlerChain;
        }
        return null;
    }

    private CommonConfig getCommonConfig(String configType, String configName) {
        Collection<? extends CommonConfig> commonConfigs = this.getCommonConfigs(configType);
        for (CommonConfig commonConfig : commonConfigs) {
            if (!configName.equals(commonConfig.getConfigName())) continue;
            return commonConfig;
        }
        throw XtsAsMessages.MESSAGES.commonConfigurationUnavailable();
    }

    private Collection<? extends CommonConfig> getCommonConfigs(String configType) {
        if (CLIENT_CONFIG_TYPE.equals(configType)) {
            return this.serverConfig.getClientConfigs();
        }
        return Collections.emptyList();
    }
}

