/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import javax.ejb.EJBException;
import javax.ejb.TransactionManagementType;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTransactionMarker;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.tx.OwnableReentrantLock;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class StatefulSessionSynchronizationInterceptor
extends AbstractEJBInterceptor {
    private final Object threadLock = new Object();
    private final OwnableReentrantLock lock = new OwnableReentrantLock();
    private final boolean containerManagedTransactions;
    private boolean synchronizationRegistered = false;
    private static final Factory CONTAINER_MANAGED = new Factory(TransactionManagementType.CONTAINER);
    private static final Factory BEAN_MANAGED = new Factory(TransactionManagementType.BEAN);

    public static InterceptorFactory factory(TransactionManagementType type) {
        return type == TransactionManagementType.CONTAINER ? CONTAINER_MANAGED : BEAN_MANAGED;
    }

    public StatefulSessionSynchronizationInterceptor(boolean containerManagedTransactions) {
        this.containerManagedTransactions = containerManagedTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error handleThrowableInTxSync(StatefulSessionComponentInstance statefulSessionComponentInstance, Throwable t) {
        EjbLogger.ROOT_LOGGER.discardingStatefulComponent(statefulSessionComponentInstance, t);
        try {
            statefulSessionComponentInstance.discard();
        }
        finally {
            this.releaseLock();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw (EJBException)new EJBException().initCause(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulSessionSynchronizationInterceptor.getComponent(context, StatefulSessionComponent.class);
        StatefulSessionComponentInstance instance = StatefulComponentInstanceInterceptor.getComponentInstance(context);
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
        Object lockOwner = this.getLockOwner(transactionSynchronizationRegistry);
        this.lock.pushOwner(lockOwner);
        try {
            boolean acquired;
            AccessTimeoutDetails timeout = component.getAccessTimeout(context.getMethod());
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Trying to acquire lock: " + this.lock + " for stateful component instance: " + instance + " during invocation: " + context);
            }
            if (!(acquired = this.lock.tryLock(timeout.getValue(), timeout.getTimeUnit()))) {
                throw EjbMessages.MESSAGES.failToObtainLock(context, timeout.getValue(), timeout.getTimeUnit());
            }
            Object object = this.threadLock;
            synchronized (object) {
                Object object2;
                block22: {
                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                        EjbLogger.ROOT_LOGGER.trace("Acquired lock: " + this.lock + " for stateful component instance: " + instance + " during invocation: " + context);
                    }
                    Object currentTransactionKey = null;
                    boolean wasTxSyncRegistered = false;
                    try {
                        if (this.containerManagedTransactions) {
                            if (!this.synchronizationRegistered) {
                                currentTransactionKey = transactionSynchronizationRegistry.getTransactionKey();
                                int status = transactionSynchronizationRegistry.getTransactionStatus();
                                if (currentTransactionKey != null && status != 3) {
                                    StatefulSessionSynchronization statefulSessionSync = new StatefulSessionSynchronization(instance, lockOwner);
                                    transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)statefulSessionSync);
                                    wasTxSyncRegistered = true;
                                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                                        EjbLogger.ROOT_LOGGER.trace("Registered tx synchronization: " + statefulSessionSync + " for tx: " + currentTransactionKey + " associated with stateful component instance: " + instance);
                                    }
                                    instance.afterBegin();
                                    this.synchronizationRegistered = true;
                                    context.putPrivateData(StatefulTransactionMarker.class, (Object)StatefulTransactionMarker.of(true));
                                }
                            } else {
                                context.putPrivateData(StatefulTransactionMarker.class, (Object)StatefulTransactionMarker.of(false));
                            }
                        }
                        object2 = context.proceed();
                        if (!wasTxSyncRegistered && !this.synchronizationRegistered) {
                            this.releaseInstance(instance);
                            break block22;
                        }
                        if (wasTxSyncRegistered) break block22;
                        this.releaseLock();
                        instance.getComponent().getCache().release(instance);
                    }
                    catch (Throwable throwable) {
                        if (!wasTxSyncRegistered && !this.synchronizationRegistered) {
                            this.releaseInstance(instance);
                        } else if (!wasTxSyncRegistered) {
                            this.releaseLock();
                            instance.getComponent().getCache().release(instance);
                        }
                        throw throwable;
                    }
                }
                return object2;
            }
        }
        finally {
            this.lock.popOwner();
        }
    }

    private Object getLockOwner(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Object owner = transactionSynchronizationRegistry.getTransactionKey();
        return owner != null ? owner : Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(StatefulSessionComponentInstance instance) {
        try {
            instance.getComponent().getCache().release(instance);
        }
        finally {
            this.synchronizationRegistered = false;
            this.releaseLock();
        }
    }

    private void releaseLock() {
        this.lock.unlock();
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Released lock: " + this.lock);
        }
    }

    private class StatefulSessionSynchronization
    implements Synchronization {
        private final StatefulSessionComponentInstance statefulSessionComponentInstance;
        private final Object lockOwner;

        StatefulSessionSynchronization(StatefulSessionComponentInstance statefulSessionComponentInstance, Object lockOwner) {
            this.statefulSessionComponentInstance = statefulSessionComponentInstance;
            this.lockOwner = lockOwner;
        }

        public void beforeCompletion() {
            try {
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("Before completion callback invoked on Transaction synchronization: " + this + " of stateful component instance: " + this.statefulSessionComponentInstance);
                }
                if (!this.statefulSessionComponentInstance.isDiscarded()) {
                    this.statefulSessionComponentInstance.beforeCompletion();
                }
            }
            catch (Throwable t) {
                throw StatefulSessionSynchronizationInterceptor.this.handleThrowableInTxSync(this.statefulSessionComponentInstance, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("After completion callback invoked on Transaction synchronization: " + this + " of stateful component instance: " + this.statefulSessionComponentInstance);
                }
                if (!this.statefulSessionComponentInstance.isDiscarded()) {
                    this.statefulSessionComponentInstance.afterCompletion(status == 3);
                }
            }
            catch (Throwable t) {
                throw StatefulSessionSynchronizationInterceptor.this.handleThrowableInTxSync(this.statefulSessionComponentInstance, t);
            }
            StatefulSessionSynchronizationInterceptor.this.lock.pushOwner(this.lockOwner);
            try {
                StatefulSessionSynchronizationInterceptor.this.releaseInstance(this.statefulSessionComponentInstance);
            }
            finally {
                StatefulSessionSynchronizationInterceptor.this.lock.popOwner();
            }
        }
    }

    private static class Factory
    extends ComponentInstanceInterceptorFactory {
        private final TransactionManagementType type;

        public Factory(TransactionManagementType type) {
            this.type = type;
        }

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new StatefulSessionSynchronizationInterceptor(this.type == TransactionManagementType.CONTAINER);
        }
    }
}

