/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import java.rmi.RemoteException;
import java.util.Random;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.TransactionAttributeType;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.MethodIntfHelper;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.util.deadlock.ApplicationDeadlockException;

public class CMTTxInterceptor
implements Interceptor {
    private static final int MAX_RETRIES = 5;
    private static final Random RANDOM = new Random();
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new CMTTxInterceptor());

    protected void endTransaction(TransactionManager tm, Transaction tx) {
        try {
            if (tx != tm.getTransaction()) {
                throw EjbMessages.MESSAGES.wrongTxOnThread(tx, tm.getTransaction());
            }
            if (tx.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        catch (RollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (SystemException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
    }

    protected int getCurrentTransactionTimeout(EJBComponent component) throws SystemException {
        TransactionManager tm = component.getTransactionManager();
        if (tm instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)tm).getTransactionTimeout();
        }
        return 0;
    }

    protected void handleEndTransactionException(Exception e) {
        if (e instanceof RollbackException) {
            throw new EJBTransactionRolledbackException("Transaction rolled back", e);
        }
        throw new EJBException(e);
    }

    protected void handleInCallerTx(InterceptorContext invocation, Throwable t, Transaction tx, EJBComponent component) throws Exception {
        ApplicationExceptionDetails ae = component.getApplicationException(t.getClass(), invocation.getMethod());
        if (ae != null) {
            if (ae.isRollback()) {
                this.setRollbackOnly(tx);
            }
            throw (Exception)t;
        }
        if (!(t instanceof EJBTransactionRolledbackException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = new EJBTransactionRolledbackException("Unexpected Error");
                t.initCause(cause);
            } else if (!(t instanceof NoSuchEJBException) && !(t instanceof NoSuchEntityException)) {
                if (t instanceof RuntimeException) {
                    t = new EJBTransactionRolledbackException(t.getMessage(), (Exception)t);
                } else {
                    throw (Exception)t;
                }
            }
        }
        this.setRollbackOnly(tx);
        EjbLogger.ROOT_LOGGER.error(t);
        throw (Exception)t;
    }

    public void handleExceptionInOurTx(InterceptorContext invocation, Throwable t, Transaction tx, EJBComponent component) throws Exception {
        ApplicationExceptionDetails ae = component.getApplicationException(t.getClass(), invocation.getMethod());
        if (ae != null) {
            if (ae.isRollback()) {
                this.setRollbackOnly(tx);
            }
            throw (Exception)t;
        }
        if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = EjbMessages.MESSAGES.unexpectedError();
                t.initCause(cause);
            } else if (t instanceof RuntimeException) {
                t = new EJBException((Exception)t);
            } else {
                throw (Exception)t;
            }
        }
        this.setRollbackOnly(tx);
        throw (Exception)t;
    }

    public void handleExceptionInNoTx(InterceptorContext invocation, Throwable t, EJBComponent component) throws Exception {
        ApplicationExceptionDetails ae = component.getApplicationException(t.getClass(), invocation.getMethod());
        if (ae != null) {
            throw (Exception)t;
        }
        if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = EjbMessages.MESSAGES.unexpectedError();
                t.initCause(cause);
            } else if (t instanceof RuntimeException) {
                t = new EJBException((Exception)t);
            } else {
                throw (Exception)t;
            }
        }
        throw (Exception)t;
    }

    public Object processInvocation(InterceptorContext invocation) throws Exception {
        EJBComponent component = (EJBComponent)((Object)invocation.getPrivateData(Component.class));
        MethodIntf methodIntf = MethodIntfHelper.of(invocation);
        TransactionAttributeType attr = component.getTransactionAttributeType(methodIntf, invocation.getMethod());
        int timeoutInSeconds = component.getTransactionTimeout(methodIntf, invocation.getMethod());
        switch (attr) {
            case MANDATORY: {
                return this.mandatory(invocation, component);
            }
            case NEVER: {
                return this.never(invocation, component);
            }
            case NOT_SUPPORTED: {
                return this.notSupported(invocation, component);
            }
            case REQUIRED: {
                return this.required(invocation, component, timeoutInSeconds);
            }
            case REQUIRES_NEW: {
                return this.requiresNew(invocation, component, timeoutInSeconds);
            }
            case SUPPORTS: {
                return this.supports(invocation, component);
            }
        }
        throw EjbMessages.MESSAGES.unknownTxAttributeOnInvocation(attr, invocation);
    }

    protected Object invokeInCallerTx(InterceptorContext invocation, Transaction tx, EJBComponent component) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            this.handleInCallerTx(invocation, t, tx, component);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(InterceptorContext invocation, EJBComponent component) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            this.handleExceptionInNoTx(invocation, t, component);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(InterceptorContext invocation, TransactionManager tm, EJBComponent component) throws Exception {
        for (int i = 0; i < 5; ++i) {
            tm.begin();
            Transaction tx = tm.getTransaction();
            try {
                Object object = invocation.proceed();
                this.endTransaction(tm, tx);
                return object;
            }
            catch (Throwable t) {
                try {
                    try {
                        this.handleExceptionInOurTx(invocation, t, tx, component);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.endTransaction(tm, tx);
                    }
                }
                catch (Exception ex) {
                    ApplicationDeadlockException deadlock = ApplicationDeadlockException.isADE((Throwable)ex);
                    if (deadlock != null) {
                        if (!deadlock.retryable() || i + 1 >= 5) {
                            throw deadlock;
                        }
                        EjbLogger.ROOT_LOGGER.retrying(deadlock.getLocalizedMessage(), i + 1);
                        Thread.sleep(RANDOM.nextInt(1 + i), RANDOM.nextInt(1000));
                        continue;
                    }
                    throw ex;
                }
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object mandatory(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx == null) {
            throw EjbMessages.MESSAGES.txRequiredForInvocation(invocation);
        }
        return this.invokeInCallerTx(invocation, tx, component);
    }

    protected Object never(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        if (tm.getTransaction() != null) {
            throw EjbMessages.MESSAGES.txPresentForNeverTxAttribute();
        }
        return this.invokeInNoTx(invocation, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object notSupported(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx != null) {
            tm.suspend();
            try {
                Object object = this.invokeInNoTx(invocation, component);
                return object;
            }
            finally {
                tm.resume(tx);
            }
        }
        return this.invokeInNoTx(invocation, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object required(InterceptorContext invocation, EJBComponent component, int timeout) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        int oldTimeout = this.getCurrentTransactionTimeout(component);
        try {
            Transaction tx;
            if (timeout != -1) {
                tm.setTransactionTimeout(timeout);
            }
            if ((tx = tm.getTransaction()) == null) {
                Object object = this.invokeInOurTx(invocation, tm, component);
                return object;
            }
            Object object = this.invokeInCallerTx(invocation, tx, component);
            return object;
        }
        finally {
            if (tm != null) {
                tm.setTransactionTimeout(oldTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object requiresNew(InterceptorContext invocation, EJBComponent component, int timeout) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        int oldTimeout = this.getCurrentTransactionTimeout(component);
        try {
            Transaction tx;
            if (timeout != -1 && tm != null) {
                tm.setTransactionTimeout(timeout);
            }
            if ((tx = tm.getTransaction()) != null) {
                tm.suspend();
                try {
                    Object object = this.invokeInOurTx(invocation, tm, component);
                    return object;
                }
                finally {
                    tm.resume(tx);
                }
            }
            Object object = this.invokeInOurTx(invocation, tm, component);
            return object;
        }
        finally {
            if (tm != null) {
                tm.setTransactionTimeout(oldTimeout);
            }
        }
    }

    protected void setRollbackOnly(Transaction tx) {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException ex) {
            EjbLogger.EJB3_LOGGER.failedToSetRollbackOnly((Exception)((Object)ex));
        }
        catch (IllegalStateException ex) {
            EjbLogger.EJB3_LOGGER.failedToSetRollbackOnly(ex);
        }
    }

    protected Object supports(InterceptorContext invocation, EJBComponent component) throws Exception {
        TransactionManager tm = component.getTransactionManager();
        Transaction tx = tm.getTransaction();
        if (tx == null) {
            return this.invokeInNoTx(invocation, component);
        }
        return this.invokeInCallerTx(invocation, tx, component);
    }
}

