/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.txframework.impl.handlers;

import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mw.wst11.BusinessActivityManagerFactory;
import com.arjuna.mw.wst11.UserTransaction;
import com.arjuna.mw.wst11.UserTransactionFactory;
import com.arjuna.wst.SystemException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jboss.narayana.txframework.api.annotation.transaction.Compensatable;
import org.jboss.narayana.txframework.api.annotation.transaction.Transactional;
import org.jboss.narayana.txframework.api.exception.TXFrameworkException;
import org.jboss.narayana.txframework.impl.ServiceInvocationMeta;
import org.jboss.narayana.txframework.impl.handlers.ProtocolHandler;
import org.jboss.narayana.txframework.impl.handlers.UnsupportedProtocolException;
import org.jboss.narayana.txframework.impl.handlers.restat.service.RESTATHandler;
import org.jboss.narayana.txframework.impl.handlers.wsat.WSATHandler;
import org.jboss.narayana.txframework.impl.handlers.wsba.WSBAHandler;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class HandlerFactory {
    private static final Map<String, ProtocolHandler> protocolHandlerMap = new HashMap<String, ProtocolHandler>();

    public static ProtocolHandler getInstance(ServiceInvocationMeta serviceInvocationMeta) throws TXFrameworkException {
        Transactional Transactional2;
        String txid = HandlerFactory.getCurrentTXID() + ":" + serviceInvocationMeta.getServiceClass();
        ProtocolHandler protocolHandler = protocolHandlerMap.get(txid);
        if (protocolHandler != null) {
            return protocolHandler;
        }
        Compensatable compensatable = serviceInvocationMeta.getServiceClass().getAnnotation(Compensatable.class);
        if (compensatable != null) {
            protocolHandler = new WSBAHandler(serviceInvocationMeta, compensatable.completionType());
        }
        if ((Transactional2 = serviceInvocationMeta.getServiceClass().getAnnotation(Transactional.class)) != null) {
            protocolHandler = HandlerFactory.isWSATTransactionRunning() ? new WSATHandler(serviceInvocationMeta) : new RESTATHandler(serviceInvocationMeta);
        }
        if (protocolHandler == null) {
            throw new UnsupportedProtocolException("Expected to find a transaction type annotation on '" + serviceInvocationMeta.getServiceClass().getName() + "'");
        }
        protocolHandlerMap.put(txid, protocolHandler);
        return protocolHandler;
    }

    private static boolean isWSATTransactionRunning() {
        UserTransaction ut = UserTransactionFactory.userTransaction();
        return !ut.transactionIdentifier().equals("Unknown");
    }

    private static String getCurrentTXID() throws TXFrameworkException {
        String txid = UserTransactionFactory.userTransaction().transactionIdentifier();
        if (!txid.equals("Unknown")) {
            return txid;
        }
        try {
            BusinessActivityManager businessActivityManager = BusinessActivityManagerFactory.businessActivityManager();
            if (businessActivityManager.currentTransaction() != null && !(txid = businessActivityManager.currentTransaction().toString()).equals("Unknown")) {
                return txid;
            }
        }
        catch (SystemException e) {
            throw new TXFrameworkException("Error when looking up Business Activity", e);
        }
        HttpServletRequest req = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        String enlistUrl = req.getHeader("enlistURL");
        if (enlistUrl != null) {
            String[] parts = enlistUrl.split("/");
            return parts[parts.length - 1];
        }
        throw new TXFrameworkException("No Transaction detected");
    }
}

