/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.Hashtable;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.notification.filter.AbstractFilter;
import org.jacorb.notification.filter.MappingFilterUsageDecorator;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.GCDisposable;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidValue;
import org.omg.CosNotifyFilter.MappingConstraintInfo;
import org.omg.CosNotifyFilter.MappingConstraintPair;
import org.omg.CosNotifyFilter.MappingFilterOperations;
import org.omg.CosNotifyFilter.MappingFilterPOATie;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.slf4j.Logger;

public class MappingFilterImpl
implements GCDisposable,
MappingFilterOperations {
    private final AbstractFilter filterDelegate_;
    private final Any defaultValue_;
    private final ValueMap valueMap_ = new ValueMap();
    private final Logger logger_;
    private final MappingFilterPOATie servant_;
    private final MappingFilterUsageDecorator usageDecorator_;
    private final ORB orb_;
    private final DisposableManager disposeHooks_ = new DisposableManager();
    private final long maxIdleTime_;

    public MappingFilterImpl(ORB orb, Configuration config, AbstractFilter filter, Any defaultValue) {
        this.orb_ = orb;
        this.logger_ = LogUtil.getLogger(config, this.getClass().getName());
        this.filterDelegate_ = filter;
        this.defaultValue_ = defaultValue;
        this.usageDecorator_ = new MappingFilterUsageDecorator(this);
        this.servant_ = new MappingFilterPOATie(this.usageDecorator_.getMappingFilterOperations());
        this.maxIdleTime_ = config.getAttributeAsLong("jacorb.notification.filter.dead_interval", 0L);
    }

    public Object activate() {
        return this.servant_._this(this.orb_);
    }

    public void destroy() {
        this.logger_.info("destroy MappingFilter");
        this.dispose();
    }

    public void dispose() {
        this.disposeHooks_.dispose();
        this.filterDelegate_.dispose();
        this.valueMap_.dispose();
    }

    public String constraint_grammar() {
        return this.filterDelegate_.constraint_grammar();
    }

    public TypeCode value_type() {
        return this.defaultValue_.type();
    }

    public Any default_value() {
        return this.defaultValue_;
    }

    public MappingConstraintInfo[] add_mapping_constraints(MappingConstraintPair[] mcp) throws InvalidValue, InvalidConstraint {
        ConstraintExp[] _constraintExpArray = new ConstraintExp[mcp.length];
        for (int x = 0; x < mcp.length; ++x) {
            _constraintExpArray[x] = mcp[x].constraint_expression;
        }
        ConstraintInfo[] _constraintInfo = this.filterDelegate_.add_constraints(_constraintExpArray);
        MappingConstraintInfo[] _mappingConstraintInfo = new MappingConstraintInfo[_constraintInfo.length];
        for (int x = 0; x < _constraintInfo.length; ++x) {
            _mappingConstraintInfo[x] = new MappingConstraintInfo(_constraintInfo[x].constraint_expression, _constraintInfo[x].constraint_id, mcp[x].result_to_set);
            this.valueMap_.put(_constraintInfo[x].constraint_id, mcp[x].result_to_set);
        }
        return _mappingConstraintInfo;
    }

    public void modify_mapping_constraints(int[] intArray, MappingConstraintInfo[] mappingConstraintInfos) throws ConstraintNotFound, InvalidValue, InvalidConstraint {
        int x;
        ConstraintInfo[] _constraintInfo = new ConstraintInfo[mappingConstraintInfos.length];
        for (x = 0; x < _constraintInfo.length; ++x) {
            _constraintInfo[x] = new ConstraintInfo(mappingConstraintInfos[x].constraint_expression, mappingConstraintInfos[x].constraint_id);
            this.valueMap_.remove(mappingConstraintInfos[x].constraint_id);
        }
        this.filterDelegate_.modify_constraints(intArray, _constraintInfo);
        for (x = 0; x < mappingConstraintInfos.length; ++x) {
            this.valueMap_.put(mappingConstraintInfos[x].constraint_id, mappingConstraintInfos[x].value);
        }
    }

    public MappingConstraintInfo[] get_mapping_constraints(int[] constraintIds) throws ConstraintNotFound {
        ConstraintInfo[] _constraintInfo = this.filterDelegate_.get_constraints(constraintIds);
        MappingConstraintInfo[] _mappingConstraintInfo = new MappingConstraintInfo[_constraintInfo.length];
        for (int x = 0; x < _constraintInfo.length; ++x) {
            _mappingConstraintInfo[x] = new MappingConstraintInfo(_constraintInfo[x].constraint_expression, _constraintInfo[x].constraint_id, this.valueMap_.get(_constraintInfo[x].constraint_id));
        }
        return _mappingConstraintInfo;
    }

    public MappingConstraintInfo[] get_all_mapping_constraints() {
        ConstraintInfo[] _constraintInfo = this.filterDelegate_.get_all_constraints();
        MappingConstraintInfo[] _mappingConstraintInfo = new MappingConstraintInfo[_constraintInfo.length];
        for (int x = 0; x < _constraintInfo.length; ++x) {
            _mappingConstraintInfo[x] = new MappingConstraintInfo(_constraintInfo[x].constraint_expression, _constraintInfo[x].constraint_id, this.valueMap_.get(_constraintInfo[x].constraint_id));
        }
        return _mappingConstraintInfo;
    }

    public void remove_all_mapping_constraints() {
        this.filterDelegate_.remove_all_constraints();
        this.valueMap_.dispose();
    }

    public boolean match(Any any, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int _filterId = this.filterDelegate_.match_internal(any);
        if (_filterId >= 0) {
            anyHolder.value = this.valueMap_.get(_filterId);
            return true;
        }
        return false;
    }

    public boolean match_structured(StructuredEvent structuredEvent, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int _filterId = this.filterDelegate_.match_structured_internal(structuredEvent);
        if (_filterId >= 0) {
            anyHolder.value = this.valueMap_.get(_filterId);
            return true;
        }
        return false;
    }

    public boolean match_typed(Property[] propertyArray, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int _filterId = this.filterDelegate_.match_typed_internal(propertyArray);
        if (_filterId >= 0) {
            anyHolder.value = this.valueMap_.get(_filterId);
            return true;
        }
        return false;
    }

    public void attemptDispose() {
        AbstractFilter.attemptDispose(this, this.usageDecorator_.getLastUsage(), this.maxIdleTime_);
    }

    public void registerDisposable(Disposable d) {
        this.disposeHooks_.addDisposable(d);
    }

    private static class ValueMap {
        private final Map valueMap_ = new Hashtable();

        private ValueMap() {
        }

        public void put(int key, Any value) {
            this.valueMap_.put(new Integer(key), value);
        }

        public Any get(int key) {
            return (Any)this.valueMap_.get(new Integer(key));
        }

        public Any remove(int key) {
            return (Any)this.valueMap_.remove(new Integer(key));
        }

        public void dispose() {
            this.valueMap_.clear();
        }
    }
}

