/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class PrintIOR {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        orb = org.omg.CORBA.ORB.init(args, null);
        jorb = (ORB)orb;
        logger = jorb.getConfiguration().getLogger("jacorb.print_ior");
        iorString = null;
        if (args.length != 2) {
            System.err.println("Usage: java PrintIOR [ -i ior_str | -f filename ]");
            System.exit(1);
        }
        if (args[0].equals("-f")) {
            try {
                br = new BufferedReader(new FileReader(args[1]), 2048);
                line = br.readLine();
                if (line == null) ** GOTO lbl29
                iorString = line;
                while (line != null) {
                    line = br.readLine();
                    if (line == null) continue;
                    iorString = iorString + line;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(1);
            }
        } else if (args[0].equals("-i")) {
            iorString = args[1];
        } else {
            System.err.println("Usage: java PrintIOR [ -i ior_str | -f filename ]");
            System.exit(1);
        }
lbl29:
        // 5 sources

        if (logger.isDebugEnabled()) {
            logger.debug("Under " + System.getProperty("os.name") + " the encoding name is " + System.getProperty("file.encoding") + " and the canonical encoding name is " + new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
        }
        out = new PrintWriter(System.out, true);
        if (iorString.startsWith("IOR:")) {
            pior = new ParsedIOR(jorb, iorString);
            PrintIOR.printIOR(pior, out);
        } else {
            out.println("Sorry, we only unparse IORs in the standard IOR URL scheme");
        }
        orb.shutdown(true);
    }

    public static void printIOR(ParsedIOR pior, PrintWriter out) {
        IOR ior = pior.getIOR();
        out.println("------IOR components-----");
        out.println("TypeId\t:\t" + ior.type_id);
        List profiles = pior.getProfiles();
        out.println("TAG_INTERNET_IOP Profiles:");
        for (int i = 0; i < profiles.size(); ++i) {
            out.println("\tProfile Id:\t\t" + i);
            IIOPProfile profile = (IIOPProfile)profiles.get(i);
            out.println("\tIIOP Version:\t\t" + profile.version().major + "." + profile.version().minor);
            out.println("\tHost:\t\t\t" + ((IIOPAddress)profile.getAddress()).getOriginalHost());
            int port = ((IIOPAddress)profile.getAddress()).getPort();
            if (port < 0) {
                port += 65536;
            }
            out.println("\tPort:\t\t\t" + port);
            out.println("\tObject key (URL):\t" + CorbaLoc.parseKey(profile.get_object_key()));
            out.print("\tObject key (hex):\t0x");
            PrintIOR.dumpHex(profile.get_object_key(), out);
            out.println();
            if (profile.version().minor >= 1) {
                if (profile.getComponents().size() > 0) {
                    out.println("\t-- Found " + profile.getComponents().size() + " Tagged Components--");
                }
                PrintIOR.printTaggedComponents(profile.getComponents().asArray(), out);
            }
            out.print("\n");
        }
        TaggedComponentList multiple_components = pior.getMultipleComponents();
        if (multiple_components.size() > 0) {
            out.println("Components in MULTIPLE_COMPONENTS profile: " + multiple_components.size());
            PrintIOR.printTaggedComponents(multiple_components.asArray(), out);
        }
    }

    private static void printTaggedComponents(TaggedComponent[] taggedComponents, PrintWriter out) {
        block11: for (int i = 0; i < taggedComponents.length; ++i) {
            switch (taggedComponents[i].tag) {
                case 20: {
                    out.println("\t#" + i + ": TAG_SSL_SEC_TRANS");
                    PrintIOR.printSSLTaggedComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 33: {
                    out.println("\t#" + i + ": TAG_CSI_SEC_MECH_LIST");
                    PrintIOR.printCSIMechComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 35: {
                    out.println("\t#" + i + ": TAG_SECIOP_SEC_TRANS");
                    continue block11;
                }
                case 3: {
                    out.println("\t#" + i + ": TAG_ALTERNATE_IIOP_ADDRESS");
                    PrintIOR.printAlternateAddress(taggedComponents[i], out);
                    continue block11;
                }
                case 1: {
                    out.println("\t#" + i + ": TAG_CODE_SETS");
                    PrintIOR.printCodeSetComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 25: {
                    out.println("\t#" + i + ": TAG_JAVA_CODEBASE");
                    PrintIOR.printJavaCodebaseComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 0: {
                    out.println("\t#" + i + ": TAG_ORB_TYPE");
                    PrintIOR.printOrbTypeComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 2: {
                    out.println("\t#" + i + ": TAG_POLICIES");
                    PrintIOR.printPolicyComponent(taggedComponents[i], out);
                    continue block11;
                }
                case 34: {
                    out.println("\t#" + i + ": TAG_NULL_TAG");
                    continue block11;
                }
                default: {
                    out.println("\tUnknown tag : " + taggedComponents[i].tag);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printCSIMechComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            CompoundSecMechList csmList = CompoundSecMechListHelper.read(is);
            if (csmList != null) {
                out.println("\t\tis stateful: " + csmList.stateful);
                for (int i = 0; i < csmList.mechanism_list.length; ++i) {
                    out.println("\t\tCompoundSecMech #" + i);
                    out.println("\t\t\ttarget_requires: " + csmList.mechanism_list[i].target_requires);
                    out.print("\t\t\ttransport mechanism tag: ");
                    switch (csmList.mechanism_list[i].transport_mech.tag) {
                        case 36: {
                            out.println("TAG_TLS_SEC_TRANS");
                            PrintIOR.printTlsSecTrans(csmList.mechanism_list[i].transport_mech.component_data, out);
                            break;
                        }
                        case 34: {
                            out.println("TAG_NULL_TAG");
                            break;
                        }
                        default: {
                            out.println("Unknown tag : " + csmList.mechanism_list[i].transport_mech.tag);
                        }
                    }
                    out.println("\t\t\tAS_ContextSec target_supports: " + csmList.mechanism_list[i].as_context_mech.target_supports);
                    out.println("\t\t\tAS_ContextSec target_requires: " + csmList.mechanism_list[i].as_context_mech.target_requires);
                    out.print("\t\t\tAS_ContextSec mech: ");
                    PrintIOR.dumpHex(csmList.mechanism_list[i].as_context_mech.client_authentication_mech, out);
                    out.println();
                    out.print("\t\t\tAS_ContextSec target_name: ");
                    PrintIOR.printNTExportedName(csmList.mechanism_list[i].as_context_mech.target_name, out);
                    out.println("\t\t\tSAS_ContextSec target_supports: " + csmList.mechanism_list[i].sas_context_mech.target_supports);
                    out.println("\t\t\tSAS_ContextSec target_requires: " + csmList.mechanism_list[i].sas_context_mech.target_requires);
                    for (int j = 0; j < csmList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms.length; ++j) {
                        out.print("\t\t\tSAS_ContextSec Naming mech: ");
                        PrintIOR.dumpHex(csmList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms[j], out);
                        out.println();
                    }
                    out.println("\t\t\tSAS_ContextSec Naming types: " + csmList.mechanism_list[i].sas_context_mech.supported_identity_types);
                    out.println();
                }
            }
        }
        finally {
            is.close();
        }
    }

    private static void printNTExportedName(byte[] nameData, PrintWriter out) {
        if (nameData.length < 2 || nameData[0] != 4 || nameData[1] != 1) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        int mechLen = (nameData[2] << 8) + nameData[3];
        if (mechLen > nameData.length - 8) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        int nameLen = (nameData[mechLen + 4] << 24) + (nameData[mechLen + 5] << 16) + (nameData[mechLen + 6] << 8) + nameData[mechLen + 7];
        if (mechLen + nameLen > nameData.length - 8) {
            PrintIOR.dumpHex(nameData, out);
            out.println();
            return;
        }
        byte[] name = new byte[nameLen];
        System.arraycopy(nameData, mechLen + 8, name, 0, nameLen);
        out.println(new String(name));
    }

    private static void printTlsSecTrans(byte[] tagData, PrintWriter out) {
        CDRInputStream in = new CDRInputStream((org.omg.CORBA.ORB)null, tagData);
        try {
            in.openEncapsulatedArray();
            TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.read(in);
            out.println("\t\t\tTLS SEC TRANS target requires: " + tls.target_requires);
            out.println("\t\t\tTLS SEC TRANS target supports: " + tls.target_supports);
            for (int i = 0; i < tls.addresses.length; ++i) {
                int ssl_port = tls.addresses[i].port;
                if (ssl_port < 0) {
                    ssl_port += 65536;
                }
                out.println("\t\t\tTLS SEC TRANS address: " + tls.addresses[i].host_name + ":" + ssl_port);
            }
        }
        catch (Exception ex) {
            out.print("\t\t\tTLS SEC TRANS: ");
            PrintIOR.dumpHex(tagData, out);
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printCodeSetComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            CodeSetComponentInfo codeSet = CodeSetComponentInfoHelper.read(is);
            if (codeSet != null) {
                int ji;
                out.println("\t\tForChar native code set Id: " + CodeSet.csName(codeSet.ForCharData.native_code_set));
                out.print("\t\tChar Conversion Code Sets: ");
                for (ji = 0; ji < codeSet.ForCharData.conversion_code_sets.length; ++ji) {
                    out.println(CodeSet.csName(codeSet.ForCharData.conversion_code_sets[ji]));
                    if (ji >= codeSet.ForCharData.conversion_code_sets.length - 1) continue;
                    out.print(", ");
                }
                if (codeSet.ForCharData.conversion_code_sets.length == 0) {
                    out.print("\n");
                }
                out.println("\t\tForWChar native code set Id: " + CodeSet.csName(codeSet.ForWcharData.native_code_set));
                out.print("\t\tWChar Conversion Code Sets: ");
                for (ji = 0; ji < codeSet.ForWcharData.conversion_code_sets.length; ++ji) {
                    out.println(CodeSet.csName(codeSet.ForWcharData.conversion_code_sets[ji]));
                    if (ji >= codeSet.ForWcharData.conversion_code_sets.length - 1) continue;
                    out.print(", ");
                }
                if (codeSet.ForCharData.conversion_code_sets.length == 0) {
                    out.print("\n");
                }
            }
        }
        finally {
            is.close();
        }
    }

    private static void printSSLTaggedComponent(TaggedComponent taggedComponent, PrintWriter out) {
        SSL ssl = null;
        if (taggedComponent.tag == 20) {
            CDRInputStream in = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
            try {
                in.openEncapsulatedArray();
                ssl = SSLHelper.read(in);
            }
            catch (Exception ex) {
                return;
            }
            int ssl_port = ssl.port;
            if (ssl_port < 0) {
                ssl_port += 65536;
            }
            out.print("\t\ttarget_supports\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_supports, out);
            out.println();
            out.print("\t\ttarget_requires\t:\t");
            PrintIOR.decodeAssociationOption(ssl.target_requires, out);
            out.println();
            out.println("\t\tSSL Port\t:\t" + ssl_port);
        }
    }

    private static void decodeAssociationOption(int option, PrintWriter out) {
        boolean first = true;
        if ((option & 1) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("NoProtection");
            first = false;
        }
        if ((option & 2) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("Integrity");
            first = false;
        }
        if ((option & 4) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("Confidentiality");
            first = false;
        }
        if ((option & 8) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("DetectReplay");
            first = false;
        }
        if ((option & 0x10) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("DetectMisordering");
            first = false;
        }
        if ((option & 0x20) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("EstablishTrustInTarget");
            first = false;
        }
        if ((option & 0x40) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("EstablishTrustInClient");
            first = false;
        }
        if ((option & 0x80) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("NoDelegation");
            first = false;
        }
        if ((option & 0x100) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("SimpleDelegation");
            first = false;
        }
        if ((option & 0x200) != 0) {
            if (!first) {
                out.print(", ");
            }
            out.print("CompositeDelegation");
            first = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printJavaCodebaseComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream in = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            in.openEncapsulatedArray();
            String codebase = in.read_string();
            out.println("\t\tCodebase: " + codebase);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printOrbTypeComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            int type = is.read_long();
            out.print("\t\tType: " + type);
            if (type == 1245790976) {
                out.println(" (JacORB)");
            } else {
                out.println(" (Foreign)");
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printAlternateAddress(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            is.openEncapsulatedArray();
            out.println("\t\tAddress: " + IIOPAddress.read(is));
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpHex(byte[] values) {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            PrintIOR.dumpHex(values, printWriter);
        }
        finally {
            printWriter.close();
        }
    }

    private static void dumpHex(byte[] values, PrintWriter out) {
        for (int i = 0; i < values.length; ++i) {
            int n1 = (values[i] & 0xFF) / 16;
            int n2 = (values[i] & 0xFF) % 16;
            char c1 = (char)(n1 > 9 ? 65 + (n1 - 10) : 48 + n1);
            char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
            out.print(c1);
            out.print(c2);
            out.print(' ');
        }
    }

    public static String dump(byte[] values) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]);
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String dump(int[] values) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i]);
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String dump(byte value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(hexDigit[value >> 4 & 0xF]);
        buffer.append(hexDigit[value & 0xF]);
        return buffer.toString();
    }

    public static String dump(short value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(hexDigit[value >> 12 & 0xF]);
        buffer.append(hexDigit[value >> 9 & 0xF]);
        buffer.append(hexDigit[value >> 4 & 0xF]);
        buffer.append(hexDigit[value & 0xF]);
        return buffer.toString();
    }

    public static String dump(int value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(hexDigit[value >> 28 & 0xF]);
        buffer.append(hexDigit[value >> 24 & 0xF]);
        buffer.append(hexDigit[value >> 20 & 0xF]);
        buffer.append(hexDigit[value >> 16 & 0xF]);
        buffer.append(hexDigit[value >> 12 & 0xF]);
        buffer.append(hexDigit[value >> 8 & 0xF]);
        buffer.append(hexDigit[value >> 4 & 0xF]);
        buffer.append(hexDigit[value & 0xF]);
        return buffer.toString();
    }

    public static String dump(byte[] values, boolean withChar) {
        StringBuffer buffer = new StringBuffer();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (0 == i % 16) {
                buffer.append('\n');
            }
            char c = values[i] > 31 && values[i] < 127 ? (char)((char)values[i]) : (char)' ';
            buffer.append(':');
            buffer.append(hexDigit[values[i] >> 4 & 0xF]);
            buffer.append(hexDigit[values[i] & 0xF]);
            buffer.append(' ');
            buffer.append(c);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPolicyComponent(TaggedComponent taggedComponent, PrintWriter out) {
        CDRInputStream is = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            int count = 0;
            is.openEncapsulatedArray();
            int len = is.read_long();
            while (len-- != 0) {
                int val = is.read_long();
                out.print("\t\t#" + count++ + ": ");
                is.openEncapsulation();
                switch (val) {
                    case 45: {
                        out.println("RTCORBA::PRIORITY_BANDED_CONNECTION");
                        val = is.read_long();
                        for (long i = 0L; i < (long)val; ++i) {
                            short low = is.read_short();
                            short high = is.read_short();
                            out.println("\t\t\tBand " + i + ": " + low + "-" + high);
                        }
                        break;
                    }
                    case 40: {
                        out.print("RTCORBA::PRIORITY_MODEL");
                        val = is.read_long();
                        switch (val) {
                            case 0: {
                                out.print(" (CLIENT_PROPAGATED, ");
                                break;
                            }
                            case 1: {
                                out.print(" (SERVER_DECLARED, ");
                                break;
                            }
                            default: {
                                out.print(" (Unknown, ");
                            }
                        }
                        short prio = is.read_short();
                        out.println(prio + ")");
                        break;
                    }
                    default: {
                        out.println("Unknown (" + val + ")");
                    }
                }
                is.closeEncapsulation();
            }
        }
        finally {
            is.close();
        }
    }
}

