/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.poa.POAManager;
import org.jacorb.poa.POAManagerMonitor;
import org.jacorb.poa.gui.POAManagerMonitorController;
import org.jacorb.poa.gui.POAManagerMonitorView;
import org.jacorb.poa.gui.pm.POAManagerFrame;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.slf4j.Logger;

public class POAManagerMonitorImpl
implements POAManagerMonitor,
POAManagerMonitorController,
Configurable {
    private POAManager model = null;
    private POAManagerMonitorView view = null;
    private Configuration configuration = null;
    private Logger logger;

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("jacorb.poa.manager_monitor");
    }

    public void actionClosePOAMonitor(String name) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"closeMonitor()\" on POAMonitor " + name);
                this.model.getRegisteredPOA(this.reducePOAName(name)).getMonitor().closeMonitor();
                this.printMessage("closeMonitor() on POAMonitor " + name + " is returned successfully");
            }
            catch (Throwable e) {
                this.printMessage("exception ocurred: " + e);
            }
        }
    }

    public void actionCloseView() {
        this.closeMonitor();
    }

    public void actionDestroyPOA(String name) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"destroy()\" on POA " + name);
                this.model.getRegisteredPOA(this.reducePOAName(name)).destroy(true, true);
                this.printMessage("destroy() on POA " + name + " is returned successfully");
            }
            catch (Throwable e) {
                this.printMessage("exception ocurred: " + e);
            }
        }
    }

    public void actionOpenPOAMonitor(String name) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"openMonitor()\" on POAMonitor " + name);
                this.model.getRegisteredPOA(this.reducePOAName(name)).getMonitor().openMonitor();
                this.printMessage("openMonitor() on POAMonitor " + name + " is returned successfully");
            }
            catch (Throwable e) {
                this.printMessage("exception ocurred: " + e);
            }
        }
    }

    public void actionSetToActive() {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"activate()\" on POAManager");
                this.model.activate();
                this.printMessage("activate() on POAManager is returned successfully");
            }
            catch (AdapterInactive e) {
                this.printMessage("exception ocurred: " + e);
                this.resetState();
            }
        }
    }

    public void actionSetToDiscarding(boolean wait) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"discard_requests(" + wait + ")\" on POAManager");
                this.model.discard_requests(wait);
                this.printMessage("discard_requests(" + wait + ") on POAManager is returned successfully");
            }
            catch (AdapterInactive e) {
                this.printMessage("exception ocurred: " + e);
                this.resetState();
            }
        }
    }

    public void actionSetToHolding(boolean wait) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"hold_requests(" + wait + ")\" on POAManager");
                this.model.hold_requests(wait);
                this.printMessage("hold_requests(" + wait + ") on POAManager is returned successfully");
            }
            catch (AdapterInactive e) {
                this.printMessage("exception ocurred: " + e);
                this.resetState();
            }
        }
    }

    public void actionSetToInactive(boolean wait, boolean etherialize) {
        if (this.model != null) {
            try {
                this.printMessage("invoke \"deactivate(" + etherialize + ", " + wait + ")\" on POAManager");
                this.model.deactivate(etherialize, wait);
                this.printMessage("deactivate(" + etherialize + ", " + wait + ") on POAManager is returned successfully");
            }
            catch (AdapterInactive e) {
                this.printMessage("exception ocurred: " + e);
                this.resetState();
            }
        }
    }

    public synchronized void addPOA(String name) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._addPOA(this.expandPOAName(name));
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in addPOA()" + exception.getMessage());
                }
            }
            this.printMessage("register POA " + name);
        }
    }

    public synchronized void closeMonitor() {
        block3: {
            if (this.view != null) {
                try {
                    POAManagerMonitor newMonitor = (POAManagerMonitor)Class.forName("org.jacorb.poa.POAManagerMonitorImpl").newInstance();
                    newMonitor.init(this.model);
                    newMonitor.configure(this.configuration);
                    this.model.setMonitor(newMonitor);
                    POAManagerMonitorView tmp = this.view;
                    this.view = null;
                    tmp._destroy();
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in closeMonitor" + exception.getMessage());
                }
            }
        }
    }

    private String expandPOAName(String name) {
        return name.equals("") ? "RootPOA" : "RootPOA/" + name;
    }

    public void init(POAManager poaManager) {
        this.model = poaManager;
    }

    public synchronized void openMonitor() {
        block2: {
            try {
                this.view = new POAManagerFrame(this);
                this.view._setVisible(true);
            }
            catch (Throwable exception) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Exception in openMonitor" + exception.getMessage());
            }
        }
    }

    public synchronized void printMessage(String str) {
        block3: {
            if (this.view != null) {
                try {
                    this.view._printMessage(str);
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception int printMessage(): " + exception.getMessage());
                }
            }
        }
    }

    private String reducePOAName(String name) {
        return name.equals("RootPOA") ? "" : name.substring("RootPOA".length() + 1);
    }

    public synchronized void removePOA(String name) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._removePOA(this.expandPOAName(name));
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in printMessage(): " + exception.getMessage());
                }
            }
            this.printMessage("unregister POA " + name);
        }
    }

    protected synchronized void resetState() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._resetState();
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in resetState(): " + exception.getMessage());
                }
            }
        }
    }

    public synchronized void setToActive() {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToActive();
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToActive(): " + exception.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"active\"");
        }
    }

    public synchronized void setToDiscarding(boolean wait) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToDiscarding(wait);
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToActive(): " + exception.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"discarding\"");
        }
    }

    public synchronized void setToHolding(boolean wait) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToHolding(wait);
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToHolding(): " + exception.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"holding\"");
        }
    }

    public synchronized void setToInactive(boolean wait, boolean etherialize) {
        if (this.view != null) {
            block3: {
                try {
                    this.view._setToInactive(wait, etherialize);
                }
                catch (Throwable exception) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Exception in setToInactive(): " + exception.getMessage());
                }
            }
            this.printMessage("POAManager is set to \"inactive\"");
        }
    }
}

