/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.repository.Namespace100;
import org.jboss.osgi.repository.RepositoryContentHelper;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryReader;
import org.jboss.osgi.repository.RepositoryStorageException;
import org.jboss.osgi.repository.RepositoryWriter;
import org.jboss.osgi.repository.RepositoryXMLReader;
import org.jboss.osgi.repository.RepositoryXMLWriter;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.MemoryRepositoryStorage;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.RepositoryContent;

public class FileBasedRepositoryStorage
extends MemoryRepositoryStorage {
    public static final String REPOSITORY_XML_NAME = "repository.xml";
    private final File storageDir;
    private final File repoFile;

    public FileBasedRepositoryStorage(XRepository repository, File storageDir) {
        super(repository);
        if (storageDir == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("storageDir");
        }
        this.storageDir = storageDir;
        this.repoFile = new File(storageDir.getAbsolutePath() + File.separator + REPOSITORY_XML_NAME);
        if (this.repoFile.exists()) {
            RepositoryReader reader;
            try {
                reader = RepositoryXMLReader.create((InputStream)new FileInputStream(this.repoFile));
            }
            catch (IOException ex) {
                throw RepositoryMessages.MESSAGES.cannotInitializeRepositoryReader((Throwable)ex);
            }
            Long increment = new Long((String)reader.getRepositoryAttributes().get(Namespace100.Attribute.INCREMENT.getLocalName()));
            XResource res = reader.nextResource();
            while (res != null) {
                this.addResourceInternal(res, false);
                res = reader.nextResource();
            }
            long delta = increment - this.getAtomicIncrement().get();
            this.getAtomicIncrement().addAndGet(delta);
            reader.close();
        }
    }

    public XResource addResource(String mime, InputStream input) throws RepositoryStorageException {
        XResourceBuilder<XResource> builder = this.createResourceInternal(input, mime, true);
        return this.addResourceInternal(builder.getResource(), true);
    }

    public XResource addResource(XResource res) throws RepositoryStorageException {
        return this.addResourceInternal(res, true);
    }

    private synchronized XResource addResourceInternal(XResource res, boolean writeXML) throws RepositoryStorageException {
        XResource result;
        List ccaps = res.getCapabilities("osgi.content");
        if (ccaps.isEmpty()) {
            throw RepositoryMessages.MESSAGES.cannotObtainContentCapablility(res);
        }
        XCapability ccap = (XCapability)ccaps.get(0);
        String contentURL = (String)ccap.getAttribute("url");
        if (contentURL == null) {
            throw RepositoryMessages.MESSAGES.cannotObtainContentURL(res);
        }
        if (!contentURL.startsWith(this.getBaseURL().toExternalForm())) {
            XResourceBuilder<XResource> builder = this.createResourceInternal(res, false);
            for (Capability cap : res.getCapabilities(null)) {
                if ("osgi.content".equals(cap.getNamespace())) continue;
                builder.addCapability(cap.getNamespace(), cap.getAttributes(), cap.getDirectives());
            }
            for (Requirement req : res.getRequirements(null)) {
                String namespace = req.getNamespace();
                builder.addRequirement(namespace, req.getAttributes(), req.getDirectives());
            }
            result = builder.getResource();
        } else {
            result = res;
        }
        result = super.addResource(result);
        if (writeXML) {
            this.writeRepositoryXML();
        }
        return result;
    }

    public boolean removeResource(XResource res) throws RepositoryStorageException {
        return this.removeResourceInternal(res, true);
    }

    private synchronized boolean removeResourceInternal(XResource res, boolean writeXML) {
        XCapability ccap = (XCapability)res.getCapabilities("osgi.content").get(0);
        String fileURL = (String)ccap.getAttribute("url");
        File contentFile = new File(fileURL.substring("file:".length()));
        boolean result = true;
        if (contentFile.exists()) {
            result = this.deleteRecursive(contentFile.getParentFile());
        }
        result &= super.removeResource(res);
        if (writeXML) {
            this.writeRepositoryXML();
        }
        return result;
    }

    private XResourceBuilder<XResource> createResourceInternal(XResource resource, boolean loadMetadata) {
        XResourceBuilder factory = null;
        for (Capability cap : resource.getCapabilities("osgi.content")) {
            XCapability ccap = (XCapability)cap;
            HashMap<String, Object> contentAtts = new HashMap<String, Object>();
            String mimeType = (String)ccap.getAttribute("mime");
            if (mimeType != null) {
                contentAtts.put("mime", mimeType);
            }
            InputStream input = this.getResourceContent(ccap);
            try {
                URL contentURL = this.addResourceContent(input, contentAtts);
                if (factory == null) {
                    factory = URLResourceBuilderFactory.create((URL)contentURL, contentAtts, (boolean)loadMetadata);
                    continue;
                }
                factory.addCapability("osgi.content", contentAtts, null);
            }
            catch (IOException ex) {
                throw RepositoryMessages.MESSAGES.cannotAddResourceToStorage((Throwable)ex, mimeType);
            }
        }
        return factory;
    }

    private InputStream getResourceContent(XCapability ccap) {
        InputStream input;
        Resource resource = ccap.getResource();
        Capability defaultContent = (Capability)resource.getCapabilities("osgi.content").get(0);
        if (defaultContent == ccap && resource instanceof RepositoryContent) {
            input = ((RepositoryContent)resource).getContent();
        } else {
            String contentURL = (String)ccap.getAttribute("url");
            try {
                input = new URL(contentURL).openStream();
            }
            catch (IOException ex) {
                throw RepositoryMessages.MESSAGES.cannotAccessContentURL((Throwable)ex, contentURL);
            }
        }
        return input;
    }

    private XResourceBuilder<XResource> createResourceInternal(InputStream input, String mimeType, boolean loadMetadata) {
        HashMap<String, Object> contentAtts = new HashMap<String, Object>();
        if (mimeType != null) {
            contentAtts.put("mime", mimeType);
        }
        try {
            URL contentURL = this.addResourceContent(input, contentAtts);
            return URLResourceBuilderFactory.create((URL)contentURL, contentAtts, (boolean)loadMetadata);
        }
        catch (IOException ex) {
            throw RepositoryMessages.MESSAGES.cannotAddResourceToStorage((Throwable)ex, mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL addResourceContent(InputStream input, Map<String, Object> atts) throws IOException {
        File file = this.storageDir;
        synchronized (file) {
            String sha256;
            File tempFile = new File(this.storageDir.getAbsolutePath() + File.separator + "temp-content");
            Long size = this.copyResourceContent(input, tempFile);
            atts.put("size", size);
            String algorithm = "SHA-256";
            try {
                sha256 = RepositoryContentHelper.getDigest((InputStream)new FileInputStream(tempFile), (String)algorithm);
                atts.put("osgi.content", sha256);
            }
            catch (NoSuchAlgorithmException ex) {
                throw RepositoryMessages.MESSAGES.noSuchAlgorithm((Throwable)ex, algorithm);
            }
            String contentPath = sha256.substring(0, 2) + File.separator + sha256.substring(2) + File.separator + "content";
            File targetFile = new File(this.storageDir.getAbsolutePath() + File.separator + contentPath);
            targetFile.getParentFile().mkdirs();
            tempFile.renameTo(targetFile);
            URL url = targetFile.toURI().toURL();
            atts.put("url", url.toExternalForm());
            return url;
        }
    }

    private long copyResourceContent(InputStream input, File targetFile) throws IOException {
        int len = 0;
        long total = 0L;
        byte[] buf = new byte[4096];
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(targetFile);
        while ((len = input.read(buf)) >= 0) {
            ((OutputStream)out).write(buf, 0, len);
            total += (long)len;
        }
        input.close();
        ((OutputStream)out).close();
        return total;
    }

    private URL getBaseURL() {
        try {
            return this.storageDir.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void writeRepositoryXML() {
        RepositoryWriter writer;
        try {
            writer = RepositoryXMLWriter.create((OutputStream)new FileOutputStream(this.repoFile));
        }
        catch (IOException ex) {
            throw RepositoryMessages.MESSAGES.cannotInitializeRepositoryWriter((Throwable)ex);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(Namespace100.Attribute.NAME.getLocalName(), this.getRepository().getName());
        attributes.put(Namespace100.Attribute.INCREMENT.getLocalName(), new Long(this.getAtomicIncrement().get()).toString());
        writer.writeRepositoryAttributes(attributes);
        RepositoryReader reader = this.getRepositoryReader();
        XResource resource = reader.nextResource();
        while (resource != null) {
            writer.writeResource(resource);
            resource = reader.nextResource();
        }
        writer.close();
    }

    private boolean deleteRecursive(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            for (File aux : file.listFiles()) {
                result &= this.deleteRecursive(aux);
            }
        }
        return result &= file.delete();
    }
}

