/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.coordination.DomainFinalResultHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.DomainRolloutStepHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainSlaveHandler;
import org.jboss.as.domain.controller.operations.coordination.OperationRouting;
import org.jboss.as.domain.controller.operations.coordination.OperationSlaveStepHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.as.repository.ContentRepository;
import org.jboss.dmr.ModelNode;

public class OperationCoordinatorStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final ContentRepository contentRepository;
    private final Map<String, ProxyController> hostProxies;
    private final Map<String, ProxyController> serverProxies;
    private final OperationSlaveStepHandler localSlaveHandler;
    private final DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry;
    private volatile ExecutorService executorService;
    private static final List<String> CONTENT_ADDITION_PARAMETERS = Arrays.asList("input-stream-index", "bytes", "url");

    OperationCoordinatorStepHandler(LocalHostControllerInfo localHostControllerInfo, ContentRepository contentRepository, Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, OperationSlaveStepHandler localSlaveHandler, DomainControllerRuntimeIgnoreTransformationRegistry runtimeIgnoreTransformationRegistry) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.contentRepository = contentRepository;
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.localSlaveHandler = localSlaveHandler;
        this.runtimeIgnoreTransformationRegistry = runtimeIgnoreTransformationRegistry;
    }

    void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ImmutableManagementResourceRegistration opRegistry = context.getResourceRegistration();
        OperationRouting routing = OperationRouting.determineRouting(operation, this.localHostControllerInfo, opRegistry);
        if (!this.localHostControllerInfo.isMasterDomainController() && !routing.isLocalOnly(this.localHostControllerInfo.getLocalHostName())) {
            this.routeToMasterDomainController(context, operation);
        } else if (routing.getSingleHost() != null && !this.localHostControllerInfo.getLocalHostName().equals(routing.getSingleHost())) {
            if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.trace("Remote single host");
            }
            this.executeDirect(context, operation);
        } else if (!routing.isTwoStep()) {
            this.executeDirect(context, operation);
        } else {
            this.executeTwoPhaseOperation(context, operation, routing);
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private ExecutorService getExecutorService() {
        return this.executorService == null ? Executors.newSingleThreadExecutor() : this.executorService;
    }

    private void routeToMasterDomainController(OperationContext context, ModelNode operation) {
        context.getFailureDescription().set(DomainControllerMessages.MESSAGES.masterDomainControllerOnlyOperation(operation.get("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address"))));
        context.stepCompleted();
    }

    private void executeDirect(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.trace("Executing direct");
        }
        String operationName = operation.require("operation").asString();
        OperationStepHandler stepHandler = null;
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration != null) {
            stepHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, operationName);
        }
        if (stepHandler != null) {
            context.addStep(stepHandler, OperationContext.Stage.MODEL);
        } else {
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
            if (registration == null) {
                context.getFailureDescription().set(ControllerMessages.MESSAGES.noSuchResourceType(pathAddress));
            } else {
                context.getFailureDescription().set(ControllerMessages.MESSAGES.noHandlerForOperation(operationName, pathAddress));
            }
        }
        context.stepCompleted();
    }

    private void executeTwoPhaseOperation(OperationContext context, ModelNode operation, OperationRouting routing) throws OperationFailedException {
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.trace("Executing two-phase");
        }
        DomainOperationContext overallContext = new DomainOperationContext(this.localHostControllerInfo);
        ModelNode rolloutPlan = operation.hasDefined("operation-headers") && operation.get("operation-headers").has("rollout-plan") ? operation.get("operation-headers").remove("rollout-plan") : new ModelNode();
        context.addStep((OperationStepHandler)new DomainFinalResultHandler(overallContext), OperationContext.Stage.MODEL);
        ModelNode slaveOp = operation.clone();
        this.storeDeploymentContent(slaveOp, context);
        slaveOp.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        slaveOp.protect();
        String localHostName = this.localHostControllerInfo.getLocalHostName();
        if (routing.isLocalCallNeeded(localHostName)) {
            ModelNode localResponse = overallContext.getCoordinatorResult();
            this.localSlaveHandler.addSteps(context, slaveOp.clone(), localResponse, false);
        }
        if (this.localHostControllerInfo.isMasterDomainController()) {
            HashSet<String> remoteHosts = new HashSet<String>(routing.getHosts());
            boolean global = remoteHosts.size() == 0;
            remoteHosts.remove(localHostName);
            if (remoteHosts.size() > 0 || global) {
                context.acquireControllerLock();
                if (global) {
                    remoteHosts.addAll(this.hostProxies.keySet());
                }
                HashMap<String, ProxyController> remoteProxies = new HashMap<String, ProxyController>();
                for (String host : remoteHosts) {
                    ProxyController proxy = this.hostProxies.get(host);
                    if (proxy != null) {
                        remoteProxies.put(host, proxy);
                        continue;
                    }
                    if (global) continue;
                    throw DomainControllerMessages.MESSAGES.invalidOperationTargetHost(host);
                }
                context.addStep(slaveOp.clone(), (OperationStepHandler)new DomainSlaveHandler(remoteProxies, overallContext, this.runtimeIgnoreTransformationRegistry), OperationContext.Stage.DOMAIN);
            }
        }
        context.addStep((OperationStepHandler)new DomainRolloutStepHandler(this.hostProxies, this.serverProxies, overallContext, rolloutPlan, this.getExecutorService()), OperationContext.Stage.DOMAIN);
        context.stepCompleted();
    }

    private void storeDeploymentContent(ModelNode opNode, OperationContext context) throws OperationFailedException {
        try {
            PathAddress address = PathAddress.pathAddress((ModelNode)opNode.get("address"));
            if (address.size() == 0) {
                String opName = opNode.get("operation").asString();
                if ("full-replace-deployment".equals(opName) && this.hasStorableContent(opNode)) {
                    byte[] hash = DeploymentUploadUtil.storeDeploymentContent(context, opNode, this.contentRepository);
                    this.hashOnlyContent(opNode, hash);
                } else if ("composite".equals(opName) && opNode.hasDefined("steps")) {
                    for (ModelNode childOp : opNode.get("steps").asList()) {
                        this.storeDeploymentContent(childOp, context);
                    }
                }
            } else if (address.size() == 1 && "deployment".equals(address.getElement(0).getKey()) && "add".equals(opNode.get("operation").asString()) && this.hasStorableContent(opNode)) {
                byte[] hash = DeploymentUploadUtil.storeDeploymentContent(context, opNode, this.contentRepository);
                this.hashOnlyContent(opNode, hash);
            }
        }
        catch (IOException ioe) {
            throw DomainControllerMessages.MESSAGES.caughtExceptionStoringDeploymentContent(ioe.getClass().getSimpleName(), ioe);
        }
    }

    private void hashOnlyContent(ModelNode operation, byte[] hash) {
        ModelNode content = new ModelNode();
        content.get("hash").set(hash);
        operation.get("content").clear();
        operation.get("content").add(content);
    }

    private boolean hasStorableContent(ModelNode operation) {
        if (operation.hasDefined("content")) {
            ModelNode content = operation.require("content");
            for (ModelNode item : content.asList()) {
                if (!OperationCoordinatorStepHandler.hasValidContentAdditionParameterDefined(item)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasValidContentAdditionParameterDefined(ModelNode item) {
        for (String s : CONTENT_ADDITION_PARAMETERS) {
            if (!item.hasDefined(s)) continue;
            return true;
        }
        return false;
    }
}

