/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ComponentRegistry {
    public static ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"ee", "ComponentRegistry"});
    private final Map<Class<?>, ComponentManagedReferenceFactory> componentsByClass = new ConcurrentHashMap();
    private final ServiceRegistry serviceRegistry;

    public ComponentRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void addComponent(ComponentConfiguration componentConfiguration) {
        this.componentsByClass.put(componentConfiguration.getComponentClass(), new ComponentManagedReferenceFactory(componentConfiguration.getComponentDescription().getStartServiceName()));
    }

    public ManagedReference createInstance(Class<?> componentClass) {
        ManagedReferenceFactory factory = this.componentsByClass.get(componentClass);
        if (factory == null) {
            return null;
        }
        return factory.getReference();
    }

    public ManagedReference createInstance(Object instance) {
        ComponentManagedReferenceFactory factory = this.componentsByClass.get(instance.getClass());
        if (factory == null) {
            return null;
        }
        return factory.getReference(instance);
    }

    public Map<Class<?>, ComponentManagedReferenceFactory> getComponentsByClass() {
        return Collections.unmodifiableMap(this.componentsByClass);
    }

    public class ComponentManagedReferenceFactory
    implements ManagedReferenceFactory {
        private final ServiceName serviceName;
        private volatile ServiceController<Component> component;

        private ComponentManagedReferenceFactory(ServiceName serviceName) {
            this.serviceName = serviceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedReference getReference() {
            if (this.component == null) {
                ComponentManagedReferenceFactory componentManagedReferenceFactory = this;
                synchronized (componentManagedReferenceFactory) {
                    if (this.component == null) {
                        this.component = ComponentRegistry.this.serviceRegistry.getService(this.serviceName);
                    }
                }
            }
            if (this.component == null) {
                return null;
            }
            return new ComponentManagedReference(((Component)this.component.getValue()).createInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedReference getReference(Object instance) {
            if (this.component == null) {
                ComponentManagedReferenceFactory componentManagedReferenceFactory = this;
                synchronized (componentManagedReferenceFactory) {
                    if (this.component == null) {
                        this.component = ComponentRegistry.this.serviceRegistry.getService(this.serviceName);
                    }
                }
            }
            if (this.component == null) {
                return null;
            }
            return new ComponentManagedReference(((Component)this.component.getValue()).createInstance(instance));
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }
    }

    private static class ComponentManagedReference
    implements ManagedReference {
        private final ComponentInstance instance;
        private boolean destroyed;

        public ComponentManagedReference(ComponentInstance component) {
            this.instance = component;
        }

        public synchronized void release() {
            if (!this.destroyed) {
                this.instance.destroy();
                this.destroyed = true;
            }
        }

        public Object getInstance() {
            return this.instance.getInstance();
        }
    }
}

