/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.subsystem.EESubsystemParser10;
import org.jboss.as.ee.subsystem.EESubsystemParser11;
import org.jboss.as.ee.subsystem.EESubsystemParser20;
import org.jboss.as.ee.subsystem.EESubsystemXmlPersister;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class EeExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "ee";
    private static final String RESOURCE_NAME = EeExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 2;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    protected static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"ee");

    static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, EeExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 2, 0, 0);
        ManagementResourceRegistration rootResource = subsystem.registerSubsystemModel((ResourceDefinition)EeSubsystemRootResource.INSTANCE);
        rootResource.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)EESubsystemXmlPersister.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.EE_1_0.getUriString(), (XMLElementReader)EESubsystemParser10.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.EE_1_1.getUriString(), (XMLElementReader)EESubsystemParser11.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.EE_2_0.getUriString(), (XMLElementReader)EESubsystemParser20.INSTANCE);
    }

    private void registerTransformers(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        GlobalModulesRejecterConverter globalModulesRejecterConverter = new GlobalModulesRejecterConverter();
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new JBossDescriptorPropertyReplacementRejectChecker(), new AttributeDefinition[]{EeSubsystemRootResource.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT})).addRejectCheck((RejectAttributeChecker)globalModulesRejecterConverter, new AttributeDefinition[]{GlobalModulesDefinition.INSTANCE})).setValueConverter((AttributeConverter)globalModulesRejecterConverter, new AttributeDefinition[]{GlobalModulesDefinition.INSTANCE});
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)0, (int)0));
    }

    private static class GlobalModulesRejecterConverter
    extends RejectAttributeChecker.DefaultRejectAttributeChecker
    implements AttributeConverter {
        private final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");

        private GlobalModulesRejecterConverter() {
        }

        public void convertOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
            this.cleanModel(attributeValue);
        }

        public void convertResourceAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            this.cleanModel(attributeValue);
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode node : attributeValue.asList()) {
                    ModelNode metaInf;
                    ModelNode services;
                    ModelNode annotations;
                    if (node.hasDefined("annotations") && (this.EXPRESSION_PATTERN.matcher((annotations = node.get("annotations")).asString()).matches() || annotations.asBoolean())) {
                        return true;
                    }
                    if (node.hasDefined("services") && (this.EXPRESSION_PATTERN.matcher((services = node.get("services")).asString()).matches() || !services.asBoolean())) {
                        return true;
                    }
                    if (!node.hasDefined("meta-inf") || !this.EXPRESSION_PATTERN.matcher((metaInf = node.get("meta-inf")).asString()).matches() && !metaInf.asBoolean()) continue;
                    return true;
                }
            }
            return false;
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return EeMessages.MESSAGES.propertiesNotAllowedOnGlobalModules();
        }

        private void cleanModel(ModelNode attributeValue) {
            if (attributeValue.isDefined()) {
                for (ModelNode node : attributeValue.asList()) {
                    node.remove("annotations");
                    node.remove("services");
                    node.remove("meta-inf");
                }
            }
        }
    }

    private static class JBossDescriptorPropertyReplacementRejectChecker
    extends RejectAttributeChecker.DefaultRejectAttributeChecker {
        private JBossDescriptorPropertyReplacementRejectChecker() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return EeMessages.MESSAGES.onlyTrueAllowedForJBossDescriptorPropertyReplacement_AS7_4892();
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            ModelVersion version;
            if (attributeValue.isDefined() && (version = context.getTarget().getVersion()).getMajor() == 1 && version.getMinor() == 2) {
                if (attributeValue.getType() == ModelType.BOOLEAN) {
                    return !attributeValue.asBoolean();
                }
                if (!Boolean.parseBoolean(attributeValue.asString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

