/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.configadmin;

import java.util.Dictionary;
import java.util.Set;
import org.jboss.as.configadmin.ConfigAdminListener;
import org.jboss.as.configadmin.ConfigAdminLogger;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

class DomainModelListener
implements ConfigAdminListener {
    static final String SKIP_CONFIGURATION_ADMIN_UPDATE = ".transient.skip.cm.update";
    private final ServiceTracker tracker;

    public DomainModelListener(BundleContext context) {
        this.tracker = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null);
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    public void configurationModified(String pid, Dictionary<String, String> dictionary) {
        ConfigAdminLogger.LOGGER.debugf("DomainModelListener modified %s => %s", (Object)pid, dictionary);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.tracker.getService();
        if (configurationAdmin == null) {
            ConfigAdminLogger.LOGGER.debugf("No ConfigurationAdmin", new Object[0]);
            return;
        }
        try {
            if (dictionary == null) {
                Configuration[] configs = configurationAdmin.listConfigurations("(service.pid=" + pid + ")");
                if (configs != null) {
                    for (Configuration config : configs) {
                        config.delete();
                    }
                }
                return;
            }
            String skipUpdate = dictionary.get(SKIP_CONFIGURATION_ADMIN_UPDATE);
            if (!Boolean.parseBoolean(skipUpdate)) {
                Configuration config = configurationAdmin.getConfiguration(pid, null);
                config.update(dictionary);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getPIDs() {
        return null;
    }
}

