/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.mail.extension.MailExtension;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class MailSessionDefinition
extends SimpleResourceDefinition {
    static final MailSessionDefinition INSTANCE = new MailSessionDefinition();
    protected static final SimpleAttributeDefinition JNDI_NAME = new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, false).setAllowExpression(true).setRestartAllServices().build();
    protected static final SimpleAttributeDefinition FROM = new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, true).setRestartAllServices().setAllowExpression(true).setAllowNull(true).build();
    protected static final SimpleAttributeDefinition DEBUG = new SimpleAttributeDefinitionBuilder("debug", ModelType.BOOLEAN, true).setAllowExpression(true).setDefaultValue(new ModelNode(false)).setRestartAllServices().build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DEBUG, JNDI_NAME, FROM};

    private MailSessionDefinition() {
        super(MailExtension.MAIL_SESSION_PATH, (ResourceDescriptionResolver)MailExtension.getResourceDescriptionResolver("mail-session"), (OperationStepHandler)MailSessionAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration rootResourceRegistration) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            rootResourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    private static class SessionAttributeWriteHandler
    extends AbstractWriteAttributeHandler {
        protected static SessionAttributeWriteHandler INSTANCE = new SessionAttributeWriteHandler();

        private SessionAttributeWriteHandler() {
            super(ATTRIBUTES);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder handbackHolder) throws OperationFailedException {
            String jndiName = JNDI_NAME.resolveModelAttribute(context, context.readResource(PathAddress.EMPTY_ADDRESS).getModel()).asString();
            ServiceName serviceName = MailSessionAdd.MAIL_SESSION_SERVICE_NAME.append(new String[]{jndiName});
            AttributeDefinition def = this.getAttributeDefinition(attributeName);
            ServiceController svcCtrl = context.getServiceRegistry(false).getService(serviceName);
            context.removeService(svcCtrl);
            MailSessionService service = (MailSessionService)svcCtrl.getService();
            if (def == DEBUG) {
                service.getConfig().setDebug(resolvedValue.asBoolean());
            } else if (def == FROM) {
                service.getConfig().setFrom(resolvedValue.asString());
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
        }
    }
}

