/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.services.resourceadapters.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class ResourceAdapterDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final DeployersLogger DEPLOYERS_LOGGER = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)"org.jboss.as.connector.deployers.RADeployer");
    private final ClassLoader classLoader;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private final Connector cmd;
    private final IronJacamar ijmd;
    private CommonDeployment raDeployment = null;
    private String deploymentName;
    private ServiceName deploymentServiceName;
    private final ServiceName duServiceName;

    public ResourceAdapterDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, Connector cmd, IronJacamar ijmd, ClassLoader classLoader, ServiceName deploymentServiceName, ServiceName duServiceName) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        this.cmd = cmd;
        this.ijmd = ijmd;
        this.classLoader = classLoader;
        this.deploymentServiceName = deploymentServiceName;
        this.duServiceName = duServiceName;
    }

    public void start(StartContext context) throws StartException {
        URL url = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getUrl();
        this.deploymentName = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getDeploymentName();
        File root = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getRoot();
        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("DEPLOYMENT name = %s", this.deploymentName);
        AS7RaDeployer raDeployer = new AS7RaDeployer(context.getChildTarget(), url, this.deploymentName, root, this.classLoader, this.cmd, this.ijmd, this.deploymentServiceName);
        raDeployer.setConfiguration((Configuration)this.config.getValue());
        ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WritableServiceBasedNamingStore.pushOwner((ServiceName)this.duServiceName);
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.raDeployment = raDeployer.doDeploy();
            this.deploymentName = this.raDeployment.getDeploymentName();
        }
        catch (Throwable t) {
            this.unregisterAll(this.deploymentName);
            throw ConnectorMessages.MESSAGES.failedToStartRaDeployment(t, this.deploymentName);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
            WritableServiceBasedNamingStore.popOwner();
        }
        if (raDeployer.checkActivation(this.cmd, this.ijmd)) {
            ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Activating: %s", this.deploymentName);
            ServiceName raServiceName = ConnectorServices.registerResourceAdapter(this.deploymentName);
            this.value = new ResourceAdapterDeployment(this.raDeployment, this.deploymentName, raServiceName);
            ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
            ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
            context.getChildTarget().addService(raServiceName, (Service)new ResourceAdapterService(this.deploymentName, raServiceName, this.value.getDeployment().getResourceAdapter())).setInitialMode(ServiceController.Mode.ACTIVE).install();
        } else {
            ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Not activating: %s", this.deploymentName);
        }
    }

    public void stop(StopContext context) {
        if (this.deploymentServiceName != null) {
            ConnectorServices.unregisterDeployment(this.raDeployment.getDeploymentName(), this.deploymentServiceName);
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Stopping sevice %s", ConnectorServices.RESOURCE_ADAPTER_DEPLOYMENT_SERVICE_PREFIX.append(new String[]{this.deploymentName}));
        this.unregisterAll(this.deploymentName);
    }

    @Override
    public void unregisterAll(String deploymentName) {
        ConnectorServices.unregisterResourceAdapterIdentifier(deploymentName);
        super.unregisterAll(deploymentName);
        if (this.mdr != null && this.mdr.getValue() != null && deploymentName != null) {
            try {
                ((AS7MetadataRepository)this.mdr.getValue()).unregisterResourceAdapter(deploymentName);
            }
            catch (Throwable t) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debug("Exception during unregistering deployment", t);
            }
        }
    }

    public CommonDeployment getRaDeployment() {
        return this.raDeployment;
    }

    public AS7MetadataRepository getMdr() {
        return (AS7MetadataRepository)this.mdr.getValue();
    }

    private class AS7RaDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractAS7RaDeployer {
        private final IronJacamar ijmd;

        public AS7RaDeployer(ServiceTarget serviceContainer, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, IronJacamar ijmd, ServiceName deploymentServiceName) {
            super(serviceContainer, url, deploymentName, root, cl, cmd, deploymentServiceName);
            this.ijmd = ijmd;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.ijmd);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            if (cmd != null) {
                HashSet<String> raMcfClasses = new HashSet<String>();
                HashSet<String> raAoClasses = new HashSet<String>();
                if (cmd.getVersion() == Connector.Version.V_10) {
                    ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                    raMcfClasses.add(ra10.getManagedConnectionFactoryClass().getValue());
                } else {
                    List aoMetas;
                    List cdMetas;
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                        for (ConnectionDefinition cdMeta : cdMetas) {
                            raMcfClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                        }
                    }
                    if (ra != null && ra.getAdminObjects() != null && (aoMetas = ra.getAdminObjects()).size() > 0) {
                        for (AdminObject aoMeta : aoMetas) {
                            raAoClasses.add(aoMeta.getAdminobjectClass().getValue());
                        }
                    }
                    if (raMcfClasses.size() == 0 && raAoClasses.size() == 0) {
                        return true;
                    }
                }
                if (ijmd != null) {
                    String clz;
                    if (ijmd.getConnectionDefinitions() != null) {
                        for (CommonConnDef def : ijmd.getConnectionDefinitions()) {
                            clz = def.getClassName();
                            if (!raMcfClasses.contains(clz)) continue;
                            return true;
                        }
                    }
                    if (ijmd.getAdminObjects() != null) {
                        for (CommonConnDef def : ijmd.getAdminObjects()) {
                            clz = def.getClassName();
                            if (!raAoClasses.contains(clz)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        protected DeployersLogger getLogger() {
            return DEPLOYERS_LOGGER;
        }
    }
}

