/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.GetRestful;

public class ResourceLocator
implements ResourceInvoker {
    static final Logger logger = Logger.getLogger(ResourceLocator.class);
    protected InjectorFactory injector;
    protected MethodInjector methodInjector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected Method method;
    protected ConcurrentHashMap<Class, Registry> cachedSubresources = new ConcurrentHashMap();

    public ResourceLocator(ResourceFactory resource, InjectorFactory injector, ResteasyProviderFactory providerFactory, Class root, Method method) {
        this.resource = resource;
        this.injector = injector;
        this.providerFactory = providerFactory;
        this.method = method;
        this.methodInjector = injector.createMethodInjector(root, method, providerFactory);
    }

    protected Object createResource(HttpRequest request, HttpResponse response) {
        Object resource = this.resource.createResource(request, response, this.providerFactory);
        return this.createResource(request, response, resource);
    }

    protected Object createResource(HttpRequest request, HttpResponse response, Object locator) {
        ResteasyUriInfo uriInfo = request.getUri();
        Object[] args = this.methodInjector.injectArguments(request, response);
        try {
            uriInfo.pushCurrentResource(locator);
            Object subResource = this.method.invoke(locator, args);
            this.warnIfJaxRSAnnotatedFields(subResource);
            return subResource;
        }
        catch (IllegalAccessException e) {
            throw new InternalServerErrorException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationException(e.getCause());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response) {
        ResteasyUriInfo uriInfo = request.getUri();
        try {
            Object target = this.createResource(request, response);
            BuiltResponse builtResponse = this.invokeOnTargetObject(request, response, target);
            return builtResponse;
        }
        finally {
            uriInfo.popCurrentResource();
            uriInfo.popMatchedURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response, Object locator) {
        ResteasyUriInfo uriInfo = request.getUri();
        try {
            Object target = this.createResource(request, response, locator);
            BuiltResponse builtResponse = this.invokeOnTargetObject(request, response, target);
            return builtResponse;
        }
        finally {
            uriInfo.popCurrentResource();
            uriInfo.popMatchedURI();
        }
    }

    protected BuiltResponse invokeOnTargetObject(HttpRequest request, HttpResponse response, Object target) {
        ResourceInvoker invoker;
        if (target == null) {
            NotFoundException notFound = new NotFoundException("Null subresource for path: " + request.getUri().getAbsolutePath());
            notFound.setLoggable(true);
            throw notFound;
        }
        Registry registry = this.cachedSubresources.get(target.getClass());
        if (registry == null) {
            registry = new ResourceMethodRegistry(this.providerFactory);
            if (!GetRestful.isSubResourceClass(target.getClass())) {
                String msg = "Subresource for target class has no jax-rs annotations.: " + target.getClass().getName();
                throw new InternalServerErrorException(msg);
            }
            if (Proxy.isProxyClass(target.getClass())) {
                registry.addResourceFactory(null, null, GetRestful.getSubResourceClasses(target.getClass()));
            } else {
                registry.addResourceFactory(null, null, target.getClass());
            }
            this.cachedSubresources.putIfAbsent(target.getClass(), registry);
        }
        if ((invoker = registry.getResourceInvoker(request)) == null) {
            NotFoundException notFound = new NotFoundException("No path match in subresource for: " + request.getUri().getAbsolutePath());
            notFound.setLoggable(true);
            throw notFound;
        }
        if (invoker instanceof ResourceLocator) {
            ResourceLocator locator = (ResourceLocator)invoker;
            return locator.invoke(request, response, target);
        }
        ResourceMethod method = (ResourceMethod)invoker;
        return method.invoke(request, response, target);
    }

    private void warnIfJaxRSAnnotatedFields(Object obj) {
        if (obj == null) {
            return;
        }
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Class<? extends Annotation>[] annotations = FindAnnotation.findJaxRSAnnotations(field.getDeclaredAnnotations());
                if (annotations.length == 0) continue;
                logger.warn("Field {0} of subresource {1} will not be injected according to spec", field.getName(), obj.getClass().getName());
            }
        }
    }
}

