/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.weld.injection.WeldInjectionContext;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class WeldInterceptorInjectionInterceptor
implements Interceptor {
    final Map<Class<?>, AtomicReference<ManagedReference>> interceptors;
    final WeldManagedReferenceFactory managedReferenceFactory;

    public WeldInterceptorInjectionInterceptor(Map<Class<?>, AtomicReference<ManagedReference>> interceptors, WeldManagedReferenceFactory managedReferenceFactory) {
        this.interceptors = interceptors;
        this.managedReferenceFactory = managedReferenceFactory;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        WeldInjectionContext injectionContext = (WeldInjectionContext)context.getPrivateData(WeldInjectionContext.class);
        for (Map.Entry<Class<?>, AtomicReference<ManagedReference>> entry : this.interceptors.entrySet()) {
            ManagedReference instance = entry.getValue().get();
            if (instance == null) continue;
            injectionContext.injectInterceptor(instance.getInstance());
        }
        return context.proceed();
    }

    public static class Factory
    implements InterceptorFactory {
        final ComponentConfiguration configuration;
        final Set<Class<?>> interceptorClasses;

        public Factory(ComponentConfiguration configuration, Set<Class<?>> interceptorClasses) {
            this.configuration = configuration;
            this.interceptorClasses = interceptorClasses;
        }

        public Interceptor create(InterceptorFactoryContext context) {
            HashMap interceptors = new HashMap();
            for (Class<?> clazz : this.interceptorClasses) {
                AtomicReference interceptor = (AtomicReference)context.getContextData().get(clazz);
                if (interceptor == null) continue;
                interceptors.put(clazz, interceptor);
            }
            WeldManagedReferenceFactory managedReferenceFactory = null;
            if (this.configuration.getInstanceFactory() instanceof WeldManagedReferenceFactory) {
                managedReferenceFactory = (WeldManagedReferenceFactory)this.configuration.getInstanceFactory();
            }
            return new WeldInterceptorInjectionInterceptor(interceptors, managedReferenceFactory);
        }
    }
}

