/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.CriteriaTools;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class SimpleAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private Object value;
    private String op;

    public SimpleAuditExpression(PropertyNameGetter propertyNameGetter, Object value, String op) {
        this.propertyNameGetter = propertyNameGetter;
        this.value = value;
        this.op = op;
    }

    @Override
    public void addToQuery(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(auditCfg, versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(auditCfg, entityName, propertyName);
        if (relatedEntity == null) {
            parameters.addWhereWithParam(propertyName, this.op, this.value);
        } else {
            if (!"=".equals(this.op) && !"<>".equals(this.op)) {
                throw new AuditException("This type of operation: " + this.op + " (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
            }
            Object id = relatedEntity.getIdMapper().mapToIdFromEntity(this.value);
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, id, null, "=".equals(this.op));
        }
    }
}

