/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.OpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Server;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public abstract class AbstractListenerService<T>
implements Service<T> {
    protected static final OptionMap SERVER_OPTIONS = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
    protected final InjectedValue<XnioWorker> worker = new InjectedValue();
    protected final InjectedValue<SocketBinding> binding = new InjectedValue();
    protected final InjectedValue<Pool> bufferPool = new InjectedValue();
    protected final InjectedValue<Server> serverService = new InjectedValue();
    private final String name;
    protected volatile OpenListener openListener;

    protected AbstractListenerService(String name) {
        this.name = name;
    }

    public InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    public InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    public InjectedValue<Pool> getBufferPool() {
        return this.bufferPool;
    }

    public InjectedValue<Server> getServerService() {
        return this.serverService;
    }

    protected int getBufferSize() {
        return 8192;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isSecure();

    protected void registerBinding() {
        ((SocketBinding)this.binding.getValue()).getSocketBindings().getNamedRegistry().registerBinding((ManagedBinding)new ListenerBinding((SocketBinding)this.binding.getValue()));
    }

    protected void unregisterBinding() {
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        binding.getSocketBindings().getNamedRegistry().unregisterBinding(binding.getName());
    }

    public void start(StartContext context) throws StartException {
        ((Server)this.serverService.getValue()).registerListener(this);
        try {
            InetSocketAddress socketAddress = ((SocketBinding)this.binding.getValue()).getSocketAddress();
            this.openListener = this.createOpenListener();
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            this.openListener.setRootHandler(((Server)this.serverService.getValue()).getRoot());
            this.startListening((XnioWorker)this.worker.getValue(), socketAddress, (ChannelListener<AcceptingChannel<StreamConnection>>)acceptListener);
            this.registerBinding();
        }
        catch (IOException e) {
            throw new StartException("Could not start http listener", (Throwable)e);
        }
    }

    public void stop(StopContext context) {
        ((Server)this.serverService.getValue()).unregisterListener(this);
        this.stopListening();
        this.unregisterBinding();
    }

    protected abstract OpenListener createOpenListener();

    abstract void startListening(XnioWorker var1, InetSocketAddress var2, ChannelListener<AcceptingChannel<StreamConnection>> var3) throws IOException;

    abstract void stopListening();

    private static class ListenerBinding
    implements ManagedBinding {
        private final SocketBinding binding;

        private ListenerBinding(SocketBinding binding) {
            this.binding = binding;
        }

        public String getSocketBindingName() {
            return this.binding.getName();
        }

        public InetSocketAddress getBindAddress() {
            return this.binding.getSocketAddress();
        }

        public void close() throws IOException {
        }
    }
}

