/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpOpenListener;
import io.undertow.server.OpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.as.network.SocketBinding;
import org.wildfly.extension.undertow.AbstractListenerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class HttpListenerService
extends AbstractListenerService<HttpListenerService> {
    private volatile AcceptingChannel<StreamConnection> server;

    public HttpListenerService(String name) {
        super(name);
    }

    @Override
    protected OpenListener createOpenListener() {
        return new HttpOpenListener((Pool)this.getBufferPool().getValue(), OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true), this.getBufferSize());
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    protected void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        this.server = worker.createStreamConnectionServer((SocketAddress)socketAddress, acceptListener, SERVER_OPTIONS);
        this.server.resumeAccepts();
        UndertowLogger.ROOT_LOGGER.listenerStarted("HTTP", this.getName(), socketAddress);
    }

    @Override
    protected void stopListening() {
        this.server.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("HTTP", this.getName());
        IoUtils.safeClose(this.server);
        this.server = null;
        UndertowLogger.ROOT_LOGGER.listenerStopped("HTTP", this.getName(), ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
    }

    public HttpListenerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

