/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jboss.as.web.common.StartupContext;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.host.ContextActivator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowMessages;

public class UndertowDeploymentService
implements Service<UndertowDeploymentService> {
    private final InjectedValue<ServletContainerService> container = new InjectedValue();
    private final WebInjectionContainer webInjectionContainer;
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<DeploymentInfo> deploymentInfoInjectedValue = new InjectedValue();
    private volatile DeploymentManager deploymentManager;

    public UndertowDeploymentService(WebInjectionContainer webInjectionContainer) {
        this.webInjectionContainer = webInjectionContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext startContext) throws StartException {
        DeploymentInfo deploymentInfo = (DeploymentInfo)this.deploymentInfoInjectedValue.getValue();
        StartupContext.setInjectionContainer((WebInjectionContainer)this.webInjectionContainer);
        try {
            this.deploymentManager = ((ServletContainerService)this.container.getValue()).getServletContainer().addDeployment(deploymentInfo);
            this.deploymentManager.deploy();
            try {
                HttpHandler handler = this.deploymentManager.start();
                ((Host)this.host.getValue()).registerDeployment(deploymentInfo, handler);
            }
            catch (ServletException e) {
                throw new StartException((Throwable)e);
            }
        }
        finally {
            StartupContext.setInjectionContainer(null);
        }
    }

    public void stop(StopContext stopContext) {
        try {
            this.deploymentManager.stop();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.deploymentManager.undeploy();
        ((Host)this.host.getValue()).unregisterDeployment((DeploymentInfo)this.deploymentInfoInjectedValue.getValue());
    }

    public UndertowDeploymentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ServletContainerService> getContainer() {
        return this.container;
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }

    public InjectedValue<DeploymentInfo> getDeploymentInfoInjectedValue() {
        return this.deploymentInfoInjectedValue;
    }

    protected static class ContextActivatorImpl
    implements ContextActivator {
        private final ServiceController<UndertowDeploymentService> controller;

        ContextActivatorImpl(ServiceController<UndertowDeploymentService> controller) {
            this.controller = controller;
        }

        public synchronized void startAsync() {
            this.controller.setMode(ServiceController.Mode.ACTIVE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean start(long timeout, TimeUnit unit) throws TimeoutException {
            if (this.controller.getMode() == ServiceController.Mode.NEVER) {
                this.controller.setMode(ServiceController.Mode.ACTIVE);
            }
            StabilityMonitor monitor = new StabilityMonitor();
            monitor.addController(this.controller);
            try {
                if (!monitor.awaitStability(timeout, unit)) {
                    throw UndertowMessages.MESSAGES.timeoutContextActivation(this.controller.getName());
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                monitor.removeController(this.controller);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean stop(long timeout, TimeUnit unit) {
            boolean result = true;
            if (this.controller.getMode() == ServiceController.Mode.ACTIVE) {
                this.controller.setMode(ServiceController.Mode.NEVER);
            }
            StabilityMonitor monitor = new StabilityMonitor();
            monitor.addController(this.controller);
            try {
                if (!monitor.awaitStability(timeout, unit)) {
                    UndertowLogger.ROOT_LOGGER.debugf("Timeout stopping context: %s", this.controller.getName());
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                monitor.removeController(this.controller);
            }
            return result;
        }

        public ServletContext getServletContext() {
            UndertowDeploymentService service = (UndertowDeploymentService)this.controller.getValue();
            Deployment deployment = service.deploymentManager.getDeployment();
            return deployment != null ? deployment.getServletContext() : null;
        }
    }
}

