/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    public static final String AUTH_EXCEPTION_KEY = "org.jboss.security.exception";

    SecurityActions() {
    }

    static SecurityContext createSecurityContext(final String domain) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                try {
                    return SecurityContextFactory.createSecurityContext((String)domain);
                }
                catch (Exception e) {
                    throw UndertowMessages.MESSAGES.failToCreateSecurityContext(e);
                }
            }
        });
    }

    static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void clearSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    static void pushRunAsIdentity(final RunAsIdentity principal) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw UndertowMessages.MESSAGES.noSecurityContext();
                }
                sc.setOutgoingRunAs((RunAs)principal);
                return null;
            }
        });
    }

    static RunAs popRunAsIdentity() {
        return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

            @Override
            public RunAs run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw UndertowMessages.MESSAGES.noSecurityContext();
                }
                RunAs principal = sc.getOutgoingRunAs();
                sc.setOutgoingRunAs(null);
                return principal;
            }
        });
    }

    static void clearAuthException() {
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc != null) {
                        sc.getData().put(SecurityActions.AUTH_EXCEPTION_KEY, null);
                    }
                    return null;
                }
            });
        } else {
            SecurityContext sc = SecurityActions.getSecurityContext();
            if (sc != null) {
                sc.getData().put(AUTH_EXCEPTION_KEY, null);
            }
        }
    }

    static Throwable getAuthException() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

                @Override
                public Throwable run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    Throwable exception = null;
                    if (sc != null) {
                        exception = (Throwable)sc.getData().get(SecurityActions.AUTH_EXCEPTION_KEY);
                    }
                    return exception;
                }
            });
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        Throwable exception = null;
        if (sc != null) {
            exception = (Throwable)sc.getData().get(AUTH_EXCEPTION_KEY);
        }
        return exception;
    }
}

