/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.wildfly.extension.undertow.session.ClusteredSession;
import org.wildfly.extension.undertow.session.SessionManager;

public class JvmRouteHandler
implements HttpHandler {
    private static final String info = "JvmRouteValve/1.0";
    private static final Logger log = Logger.getLogger(JvmRouteHandler.class);
    private final SessionManager manager;
    private final HttpHandler next;

    public JvmRouteHandler(SessionManager manager, HttpHandler next) {
        this.manager = manager;
        this.next = next;
    }

    public String getInfo() {
        return info;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("handling request %s", (Object)exchange.getRequestURI());
        }
        this.checkJvmRoute(exchange);
        this.next.handleRequest(exchange);
    }

    public void checkJvmRoute(HttpServerExchange exchange) throws IOException, ServletException {
        ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = requestContext.getOriginalRequest();
        String requestedId = request.getServletContext().getSessionCookieConfig().findSessionId(exchange);
        HttpServletRequestImpl req = (HttpServletRequestImpl)requestContext.getServletRequest();
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            String jvmRoute = this.manager.getJvmRoute();
            if (log.isTraceEnabled()) {
                log.tracef("checkJvmRoute(): check if need to re-route based on JvmRoute. Session id: %s jvmRoute: %s", (Object)sessionId, (Object)jvmRoute);
            }
            if (jvmRoute != null) {
                boolean setCookie = !req.isRequestedSessionIdFromURL();
                this.handleJvmRoute(requestedId, sessionId, jvmRoute, exchange, setCookie, requestContext);
            }
        }
    }

    protected void handleJvmRoute(String requestedId, String sessionId, String jvmRoute, HttpServerExchange exchange, boolean setCookie, ServletRequestContext servletRequestContext) throws IOException {
        String newId = null;
        Map.Entry<String, String> sessionEntry = this.manager.parse(sessionId);
        String realId = sessionEntry.getKey();
        String sessionJvmRoute = sessionEntry.getValue();
        if (sessionJvmRoute == null) {
            newId = this.manager.createSessionId(realId, jvmRoute);
        } else if (!jvmRoute.equals(sessionJvmRoute)) {
            if (log.isTraceEnabled()) {
                log.tracef("handleJvmRoute(): We have detected a failover with different jvmRoute. old one: %s, new one: %s. Will reset the session id.", (Object)sessionJvmRoute, (Object)jvmRoute);
            }
            newId = this.manager.createSessionId(realId, this.manager.locateJvmRoute(realId));
        }
        if (newId != null) {
            this.resetSessionId(exchange, sessionId, newId, servletRequestContext);
        }
        if (setCookie) {
            if (newId == null) {
                String requestedJvmRoute;
                String string = requestedJvmRoute = requestedId != null ? this.manager.parse(requestedId).getValue() : null;
                if (!jvmRoute.equals(requestedJvmRoute)) {
                    if (log.isTraceEnabled()) {
                        log.tracef("handleJvmRoute(): We have detected a failover with different jvmRoute. received one: %s, new one: %s. Will reset the session id.", (Object)requestedJvmRoute, (Object)jvmRoute);
                    }
                    newId = this.manager.createSessionId(realId, this.manager.locateJvmRoute(realId));
                }
            }
            if (newId != null) {
                HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
                request.getServletContext().getSessionCookieConfig().setSessionId(exchange, newId);
            }
        }
    }

    private void resetSessionId(HttpServerExchange exchange, String oldId, String newId, ServletRequestContext servletRequestContext) throws IOException {
        HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
        ClusteredSession session = (ClusteredSession)this.manager.getSession(exchange, (SessionConfig)request.getServletContext().getSessionCookieConfig());
        if (session != null) {
            session.resetIdWithRouteInfo(newId);
            if (log.isTraceEnabled()) {
                log.tracef("resetSessionId(): changed catalina session to= [%s] old one= [%s]", (Object)newId, (Object)oldId);
            }
        } else if (log.isTraceEnabled()) {
            log.tracef("resetSessionId(): no session with id %s found", (Object)newId);
        }
    }
}

