/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import java.util.Map;
import java.util.WeakHashMap;
import org.wildfly.extension.undertow.session.SessionManager;

public class SessionInvalidationTracker {
    private static final ThreadLocal<Map<SessionManager, String>> invalidatedSessions = new ThreadLocal();
    private static final ThreadLocal<Boolean> suspended = new ThreadLocal();

    public static void suspend() {
        suspended.set(Boolean.TRUE);
    }

    public static void resume() {
        suspended.set(null);
    }

    public static void sessionInvalidated(String id, SessionManager manager) {
        if (Boolean.TRUE != suspended.get()) {
            Map<SessionManager, String> map = invalidatedSessions.get();
            if (map == null) {
                map = new WeakHashMap<SessionManager, String>(2);
                invalidatedSessions.set(map);
            }
            map.put(manager, id);
        }
    }

    public static void clearInvalidatedSession(SessionManager manager) {
        Map<SessionManager, String> map = invalidatedSessions.get();
        if (map != null) {
            map.remove(manager);
        }
    }

    public static boolean isSessionInvalidated(String id, SessionManager manager) {
        boolean result = false;
        Map<SessionManager, String> map = invalidatedSessions.get();
        if (map != null) {
            result = id.equals(map.get(manager));
        }
        return result;
    }
}

