/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.jpa.hibernate4.management.ManagementLookup;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelNode;

public class StatisticsEnabledWriteHandler
implements OperationStepHandler {
    private final ParameterValidator validator = new StringLengthValidator(0, Integer.MAX_VALUE, false, false);
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    public StatisticsEnabledWriteHandler(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    boolean oldSetting = false;
                    ModelNode value = operation.get("value").resolve();
                    StatisticsEnabledWriteHandler.this.validator.validateResolvedParameter("value", value);
                    boolean setting = value.asBoolean();
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                    String puName = address.getLastElement().getValue();
                    final ManagementLookup stats = ManagementLookup.create(StatisticsEnabledWriteHandler.this.persistenceUnitRegistry, puName);
                    if (stats != null) {
                        oldSetting = stats.getStatistics().isStatisticsEnabled();
                        stats.getStatistics().setStatisticsEnabled(setting);
                    }
                    final boolean rollBackValue = oldSetting;
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            if (stats != null) {
                                stats.getStatistics().setStatisticsEnabled(rollBackValue);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

