/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Manifest;
import org.jboss.osgi.vfs.VFSLogger;
import org.jboss.osgi.vfs.VFSMessages;
import org.jboss.osgi.vfs.VirtualFile;

public final class VFSUtils {
    private VFSUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(VirtualFile archive) throws IOException {
        if (archive == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("archive");
        }
        VirtualFile manifest = archive.getChild("META-INF/MANIFEST.MF");
        if (manifest == null) {
            return null;
        }
        InputStream stream = manifest.openStream();
        try {
            Manifest manifest2 = new Manifest(stream);
            return manifest2;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        if (is == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("input");
        }
        if (os == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("output");
        }
        try {
            byte[] buff = new byte[65536];
            int rc = is.read(buff);
            while (rc != -1) {
                os.write(buff, 0, rc);
                rc = is.read(buff);
            }
        }
        finally {
            os.flush();
        }
    }

    public static void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception ex) {
            VFSLogger.LOGGER.tracef(ex, "Failed to close resource", new Object[0]);
        }
    }

    public static String getPathFromClassName(String className) {
        int idx = className.lastIndexOf(46);
        return idx > -1 ? VFSUtils.getPathFromPackageName(className.substring(0, idx)) : "";
    }

    public static String getPathFromPackageName(String packageName) {
        return packageName.replace('.', '/');
    }
}

