/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.io.BufferPoolResourceDefinition;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.Namespace;
import org.wildfly.extension.io.WorkerResourceDefinition;

class IOSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final IOSubsystemParser INSTANCE = new IOSubsystemParser();

    private IOSubsystemParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        WorkerResourceDefinition.INSTANCE.persist(writer, model);
        BufferPoolResourceDefinition.INSTANCE.persist(writer, model);
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{IOExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)address);
        list.add(subsystem);
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (namespace) {
                case IO_1_0: {
                    switch (reader.getLocalName()) {
                        case "worker": {
                            WorkerResourceDefinition.INSTANCE.parse(reader, address, list);
                            continue block11;
                        }
                        case "buffer-pool": {
                            BufferPoolResourceDefinition.INSTANCE.parse(reader, address, list);
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

