/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.clustering.jgroups.JGroupsMessages;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetricsHandler;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRootResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolMetricsHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;

public class ChannelInstanceResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement CHANNEL_PATH = PathElement.pathElement((String)"channel");
    private final boolean runtimeRegistration;
    static final SimpleAttributeDefinition ADDRESS = new SimpleAttributeDefinitionBuilder("address", ModelType.STRING, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition ADDRESS_AS_UUID = new SimpleAttributeDefinitionBuilder("address-as-uuid", ModelType.STRING, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition DISCARD_OWN_MESSAGES = new SimpleAttributeDefinitionBuilder("discard-own-messages", ModelType.BOOLEAN, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition NUM_TASKS_IN_TIMER = new SimpleAttributeDefinitionBuilder("num-tasks-in-timer", ModelType.INT, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition NUM_TIMER_THREADS = new SimpleAttributeDefinitionBuilder("num-timer-threads", ModelType.INT, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition RECEIVED_BYTES = new SimpleAttributeDefinitionBuilder("received-bytes", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition RECEIVED_MESSAGES = new SimpleAttributeDefinitionBuilder("received-messages", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition SENT_BYTES = new SimpleAttributeDefinitionBuilder("sent-bytes", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition SENT_MESSAGES = new SimpleAttributeDefinitionBuilder("sent-messages", ModelType.LONG, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition STATE = new SimpleAttributeDefinitionBuilder("state", ModelType.STRING, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition STATS_ENABLED = new SimpleAttributeDefinitionBuilder("stats-enabled", ModelType.BOOLEAN, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition VERSION = new SimpleAttributeDefinitionBuilder("version", ModelType.STRING, true).setStorageRuntime().build();
    static final SimpleAttributeDefinition VIEW = new SimpleAttributeDefinitionBuilder("view", ModelType.STRING, true).setStorageRuntime().build();
    static final AttributeDefinition[] CHANNEL_METRICS = new AttributeDefinition[]{ADDRESS, ADDRESS_AS_UUID, DISCARD_OWN_MESSAGES, NUM_TASKS_IN_TIMER, NUM_TIMER_THREADS, RECEIVED_BYTES, RECEIVED_MESSAGES, SENT_BYTES, SENT_MESSAGES, STATE, STATS_ENABLED, VERSION, VIEW};

    public ChannelInstanceResourceDefinition(String channelName, boolean runtimeRegistration) {
        super(PathElement.pathElement((String)"channel", (String)channelName), JGroupsExtension.getResourceDescriptionResolver("channel"), null, null);
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        if (this.runtimeRegistration) {
            for (AttributeDefinition attr : CHANNEL_METRICS) {
                resourceRegistration.registerMetric(attr, (OperationStepHandler)ChannelMetricsHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
    }

    public static void addChannelProtocolMetricsRegistrationStep(OperationContext context, String channelName, String stackName) {
        PathAddress rootSubsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsExtension.SUBSYSTEM_PATH});
        ModelNode registerProtocolsOp = Util.createOperation((String)"some_operation_name", (PathAddress)rootSubsystemAddress);
        if (stackName != null) {
            registerProtocolsOp.get("stack").set(new ModelNode(stackName));
        }
        registerProtocolsOp.get("channel").set(new ModelNode(channelName));
        context.addStep(registerProtocolsOp, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String channelName = operation.get("channel").asString();
                String stackName = null;
                if (operation.get("stack").isDefined()) {
                    stackName = operation.get("stack").asString();
                }
                ChannelInstanceResourceDefinition.registerChannelProtocolMetrics(context, channelName, stackName);
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public static void registerChannelProtocolMetrics(OperationContext context, String channelName, String stackName) throws OperationFailedException {
        if (stackName == null) {
            stackName = ChannelInstanceResourceDefinition.getDefaultStack(context);
        }
        PathElement stackElement = PathElement.pathElement((String)"stack", (String)stackName);
        PathAddress stackPath = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsExtension.SUBSYSTEM_PATH}), (PathElement[])new PathElement[]{stackElement});
        ModelNode stack = Resource.Tools.readModel((Resource)context.readResourceFromRoot(stackPath, true));
        ModelNode transport = stack.get(new String[]{"transport", "TRANSPORT"}).clone();
        String transportName = transport.get("type").asString();
        ResourceDefinition transportDefinition = ChannelInstanceResourceDefinition.getProtocolMetricResourceDefinition(context, channelName, transportName);
        List protocolOrdering = stack.get("protocols").clone().asList();
        ArrayList<ResourceDefinition> protocolDefinitions = new ArrayList<ResourceDefinition>();
        for (ModelNode protocolNameModelNode : protocolOrdering) {
            String protocolName = protocolNameModelNode.asString();
            ResourceDefinition protocolDefinition = ChannelInstanceResourceDefinition.getProtocolMetricResourceDefinition(context, channelName, protocolName);
            protocolDefinitions.add(protocolDefinition);
        }
        ManagementResourceRegistration subsystemRootRegistration = context.getResourceRegistrationForUpdate();
        ManagementResourceRegistration channelRegistration = subsystemRootRegistration.registerSubModel((ResourceDefinition)new ChannelInstanceResourceDefinition(channelName, true));
        channelRegistration.registerSubModel(transportDefinition);
        for (ResourceDefinition protocolDefinition : protocolDefinitions) {
            channelRegistration.registerSubModel(protocolDefinition);
        }
    }

    public static void addChannelProtocolMetricsDeregistrationStep(OperationContext context, String channelName) {
    }

    private static String getDefaultStack(OperationContext context) throws OperationFailedException {
        ModelNode resolvedValue = null;
        PathAddress subsystemPath = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Resource.Tools.readModel((Resource)context.readResourceFromRoot(subsystemPath));
        resolvedValue = JGroupsSubsystemRootResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, subsystem);
        return resolvedValue.isDefined() ? resolvedValue.asString() : null;
    }

    private static ResourceDefinition getProtocolMetricResourceDefinition(OperationContext context, String channelName, String protocolName) throws OperationFailedException {
        String className = "org.jgroups.protocols." + protocolName;
        Class<Protocol> protocolClass = null;
        try {
            protocolClass = Protocol.class.getClassLoader().loadClass(className).asSubclass(Protocol.class);
        }
        catch (Exception e) {
            throw JGroupsMessages.MESSAGES.unableToLoadProtocolClass(className);
        }
        Field[] fields = ChannelInstanceResourceDefinition.getProtocolFields(protocolClass);
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        HashMap<String, String> attributeDescriptionMap = new HashMap<String, String>();
        attributeDescriptionMap.put(protocolName, "The " + protocolName + " protocol");
        for (Field field : fields) {
            Property property;
            boolean equivalentTypeAvailable = ChannelInstanceResourceDefinition.isEquivalentModelTypeAvailable(field.getType());
            ManagedAttribute managed = field.getAnnotation(ManagedAttribute.class);
            if (managed != null && equivalentTypeAvailable) {
                ChannelInstanceResourceDefinition.addAttributeDefinition(attributes, attributeDescriptionMap, protocolName, field.getName(), ChannelInstanceResourceDefinition.getEquivalentModelType(field.getType()), managed.description());
            }
            if ((property = field.getAnnotation(Property.class)) == null) continue;
            if (equivalentTypeAvailable) {
                ChannelInstanceResourceDefinition.addAttributeDefinition(attributes, attributeDescriptionMap, protocolName, field.getName(), ChannelInstanceResourceDefinition.getEquivalentModelType(field.getType()), property.description());
                continue;
            }
            ChannelInstanceResourceDefinition.addAttributeDefinition(attributes, attributeDescriptionMap, protocolName, field.getName(), ModelType.STRING, property.description());
        }
        ResourceBuilder protocolBuilder = ResourceBuilder.Factory.create((PathElement)PathElement.pathElement((String)"protocol", (String)protocolName), (StandardResourceDescriptionResolver)new StandardResourceDescriptionResolver(protocolName, "org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResourceDefinition$ProtocolResources", ChannelInstanceResourceDefinition.class.getClassLoader()));
        for (AttributeDefinition def : attributes) {
            protocolBuilder.addMetric(def, (OperationStepHandler)new ProtocolMetricsHandler(protocolName));
        }
        ProtocolResources.addProtocolMapEntries(attributeDescriptionMap);
        return protocolBuilder.build();
    }

    private static void addAttributeDefinition(List<AttributeDefinition> attributes, Map<String, String> map, String protocolName, String name, ModelType type, String description) {
        SimpleAttributeDefinitionBuilder builder = new SimpleAttributeDefinitionBuilder(name, type, true);
        builder.setStorageRuntime();
        attributes.add((AttributeDefinition)builder.build());
        map.put(protocolName + "." + name, description);
    }

    public static boolean isEquivalentModelTypeAvailable(Class<?> type) {
        String[] equivalentTypes = new String[]{"int", "short", "long", "float", "double", "boolean", "class java.lang.String"};
        boolean available = false;
        for (String equivalentType : equivalentTypes) {
            if (!type.toString().equals(equivalentType)) continue;
            available = true;
            break;
        }
        return available;
    }

    private static ModelType getEquivalentModelType(Class<?> typeClass) {
        ProtocolMetricsHandler.FieldTypes type = ProtocolMetricsHandler.FieldTypes.getStat(typeClass.toString());
        switch (type) {
            case BOOLEAN: {
                return ModelType.BOOLEAN;
            }
            case BYTE: {
                return ModelType.UNDEFINED;
            }
            case CHAR: {
                return ModelType.UNDEFINED;
            }
            case SHORT: {
                return ModelType.INT;
            }
            case INT: {
                return ModelType.INT;
            }
            case LONG: {
                return ModelType.LONG;
            }
            case FLOAT: {
                return ModelType.DOUBLE;
            }
            case DOUBLE: {
                return ModelType.DOUBLE;
            }
            case STRING: {
                return ModelType.STRING;
            }
        }
        return ModelType.UNDEFINED;
    }

    private static Field[] getProtocolFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            fields.addAll(Arrays.asList(ChannelInstanceResourceDefinition.getProtocolFields(clazz.getSuperclass())));
        }
        return fields.toArray(new Field[0]);
    }

    public static class ProtocolResources
    extends ResourceBundle {
        private static Map<String, String> resources = new HashMap<String, String>();

        public static void addProtocolMapEntries(Map<String, String> map) {
            resources.putAll(map);
        }

        @Override
        public Object handleGetObject(String key) {
            return resources.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.keySet());
        }

        @Override
        protected Set<String> handleKeySet() {
            return resources.keySet();
        }
    }
}

