/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.IOException;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolConnectionManager;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public abstract class FutureManagementChannel
extends ManagementClientChannelStrategy
implements ProtocolConnectionManager.ConnectionOpenHandler {
    private final Object lock = new Object();
    private volatile Channel channel;
    private volatile boolean closed;

    @Override
    public Channel getChannel() throws IOException {
        Channel channel = this.channel;
        if (channel == null && this.closed) {
            throw ProtocolMessages.MESSAGES.channelClosed();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            StreamUtils.safeClose(this.channel);
            this.lock.notifyAll();
        }
    }

    protected boolean isConnected() {
        return this.channel != null && !this.closed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Channel awaitChannel() throws IOException {
        Channel channel = this.channel;
        if (channel != null) {
            return channel;
        }
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.closed) {
                    throw ProtocolMessages.MESSAGES.channelClosed();
                }
                channel = this.channel;
                if (channel != null) {
                    return channel;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    protected Channel openChannel(Connection connection, String serviceType, OptionMap options) throws IOException {
        IoFuture<Channel> futureChannel = connection.openChannel(serviceType, options);
        return futureChannel.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setChannel(Channel newChannel) {
        if (newChannel == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || this.channel != null) {
                return false;
            }
            this.channel = newChannel;
            this.channel.addCloseHandler(new CloseHandler<Channel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleClose(Channel closed, IOException exception) {
                    Object object = FutureManagementChannel.this.lock;
                    synchronized (object) {
                        if (FutureManagementChannel.this.channel == closed) {
                            FutureManagementChannel.this.channel = null;
                        }
                        FutureManagementChannel.this.lock.notifyAll();
                    }
                }
            });
            this.lock.notifyAll();
            return true;
        }
    }

    static class Establishing
    extends FutureManagementChannel {
        private final String serviceType;
        private final OptionMap channelOptions;
        private final Channel.Receiver receiver;
        private final ProtocolConnectionManager connectionManager;

        Establishing(String serviceType, Channel.Receiver receiver, ProtocolConnectionConfiguration configuration) {
            this.serviceType = serviceType;
            this.receiver = receiver;
            this.channelOptions = configuration.getOptionMap();
            this.connectionManager = ProtocolConnectionManager.create(configuration, (ProtocolConnectionManager.ConnectionOpenHandler)this);
        }

        @Override
        public Channel getChannel() throws IOException {
            Channel channel = super.getChannel();
            if (channel != null) {
                return channel;
            }
            this.connectionManager.connect();
            channel = super.getChannel();
            if (channel == null) {
                throw ProtocolMessages.MESSAGES.channelClosed();
            }
            return channel;
        }

        @Override
        public void connectionOpened(Connection connection) throws IOException {
            Channel channel = this.openChannel(connection, this.serviceType, this.channelOptions);
            if (this.setChannel(channel)) {
                channel.receiveMessage(this.receiver);
            } else {
                channel.closeAsync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.connectionManager.shutdown();
            }
            finally {
                super.close();
            }
        }
    }
}

