/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.nio.channels.Channel;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.WriteListenerSettable;
import org.xnio.conduits.TerminateHandler;

public interface WriteReadyHandler
extends TerminateHandler {
    public void writeReady();

    public static class ReadyTask
    implements Runnable {
        private final WriteReadyHandler handler;

        public ReadyTask(WriteReadyHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.writeReady();
        }
    }

    public static class ChannelListenerHandler<C extends Channel & WriteListenerSettable<C>>
    implements WriteReadyHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void writeReady() {
            ChannelListeners.invokeChannelListener(this.channel, ((WriteListenerSettable)this.channel).getWriteListener());
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

