/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.SSLIdentity;
import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class SSLIdentityService
implements Service<SSLIdentity>,
SSLIdentity {
    static final String SERVICE_SUFFIX = "ssl";
    private final String protocol;
    private final char[] keystorePassword;
    private final char[] keyPassword;
    private final InjectedValue<FileKeystore> keystore = new InjectedValue();
    private final InjectedValue<FileKeystore> truststore = new InjectedValue();
    private volatile SSLContext fullContext;
    private volatile SSLContext trustOnlyContext;
    private TrustManagerFactory trustManagerFactory;

    public SSLIdentityService(String protocol, char[] keystorePassword, char[] keyPassword) {
        this.protocol = protocol;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
    }

    public void start(StartContext context) throws StartException {
        try {
            KeyManager[] keyManagers = null;
            FileKeystore theKeyStore = (FileKeystore)this.keystore.getOptionalValue();
            if (theKeyStore != null && theKeyStore.getKeyStore() != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(theKeyStore.getKeyStore(), this.keyPassword == null ? this.keystorePassword : this.keyPassword);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            FileKeystore theTrustStore = (FileKeystore)this.truststore.getOptionalValue();
            if (theTrustStore != null) {
                this.trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                this.trustManagerFactory.init(theTrustStore.getKeyStore());
                TrustManager[] tmpTrustManagers = this.trustManagerFactory.getTrustManagers();
                trustManagers = new TrustManager[tmpTrustManagers.length];
                for (int i = 0; i < tmpTrustManagers.length; ++i) {
                    trustManagers[i] = new DelegatingTrustManager((X509TrustManager)tmpTrustManagers[i], theTrustStore);
                }
            }
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            sslContext.init(keyManagers, trustManagers, null);
            this.fullContext = sslContext;
            if (keyManagers != null) {
                sslContext = SSLContext.getInstance(this.protocol);
                sslContext.init(null, trustManagers, null);
            }
            this.trustOnlyContext = sslContext;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw DomainManagementMessages.MESSAGES.unableToStart(nsae);
        }
        catch (KeyManagementException kme) {
            throw DomainManagementMessages.MESSAGES.unableToStart(kme);
        }
        catch (KeyStoreException kse) {
            throw DomainManagementMessages.MESSAGES.unableToStart(kse);
        }
        catch (UnrecoverableKeyException e) {
            throw DomainManagementMessages.MESSAGES.unableToStart(e);
        }
    }

    public void stop(StopContext context) {
    }

    public SSLIdentityService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<FileKeystore> getKeyStoreInjector() {
        return this.keystore;
    }

    public InjectedValue<FileKeystore> getTrustStoreInjector() {
        return this.truststore;
    }

    @Override
    public SSLContext getFullContext() {
        return this.fullContext;
    }

    @Override
    public SSLContext getTrustOnlyContext() {
        return this.trustOnlyContext;
    }

    boolean hasTrustStore() {
        return this.truststore.getOptionalValue() != null;
    }

    private class DelegatingTrustManager
    implements X509TrustManager {
        private X509TrustManager delegate;
        private final FileKeystore theTrustStore;

        private DelegatingTrustManager(X509TrustManager trustManager, FileKeystore theTrustStore) {
            this.delegate = trustManager;
            this.theTrustStore = theTrustStore;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.getDelegate().getAcceptedIssuers();
        }

        private synchronized X509TrustManager getDelegate() {
            if (this.theTrustStore.isModified()) {
                try {
                    this.theTrustStore.load();
                }
                catch (StartException e1) {
                    throw DomainManagementMessages.MESSAGES.unableToLoadKeyTrustFile(e1.getCause());
                }
                try {
                    TrustManager[] trustManagers;
                    SSLIdentityService.this.trustManagerFactory.init(this.theTrustStore.getKeyStore());
                    for (TrustManager current : trustManagers = SSLIdentityService.this.trustManagerFactory.getTrustManagers()) {
                        if (!(current instanceof X509TrustManager)) continue;
                        this.delegate = (X509TrustManager)current;
                        break;
                    }
                }
                catch (GeneralSecurityException e) {
                    throw DomainManagementMessages.MESSAGES.unableToOperateOnTrustStore(e);
                }
            }
            if (this.delegate == null) {
                throw DomainManagementMessages.MESSAGES.unableToCreateDelegateTrustManager();
            }
            return this.delegate;
        }
    }
}

