/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.ValveBase;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CatalinaLogger;
import org.jboss.web.CatalinaMessages;

final class StandardHostValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardHostValve/1.0";

    StandardHostValve() {
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            response.sendError(500, CatalinaMessages.MESSAGES.noContext());
            return;
        }
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        context.getThreadBindingListener().bind();
        Object[] instances = context.getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (instances != null && instances.length > 0) {
            event = new ServletRequestEvent(context.getServletContext(), (ServletRequest)request.getRequest());
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerInitException(instances[i].getClass().getName()), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                    return;
                }
            }
        }
        context.getPipeline().getFirst().invoke(request, response);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            request.getSession(false);
        }
        response.setSuspended(false);
        Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (t != null) {
            this.throwable(request, response, t);
        } else {
            this.status(request, response);
        }
        if (instances != null && instances.length > 0) {
            for (int i = instances.length - 1; i >= 0; --i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t2) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerDestroyException(instances[i].getClass().getName()), t2);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t2);
                }
            }
        }
        context.getThreadBindingListener().unbind();
        Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
    }

    @Override
    public final void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        ServletRequestListener listener;
        Context context = request.getContext();
        if (request.getAsyncContext() != null) {
            Request.AsyncContextImpl asyncContext = (Request.AsyncContextImpl)request.getAsyncContext();
            if (event.getType() == HttpEvent.EventType.EVENT && asyncContext.getRunnable() == null && asyncContext.getPath() == null) {
                return;
            }
        }
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        context.getThreadBindingListener().bind();
        Object[] instances = context.getApplicationEventListeners();
        ServletRequestEvent event2 = null;
        if (instances != null && instances.length > 0) {
            event2 = new ServletRequestEvent(context.getServletContext(), (ServletRequest)request.getRequest());
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestInitialized(event2);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerInitException(instances[i].getClass().getName()), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                    Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
                    return;
                }
            }
        }
        context.getPipeline().getFirst().event(request, response, event);
        if (Globals.STRICT_SERVLET_COMPLIANCE) {
            request.getSession(false);
        }
        response.setSuspended(false);
        if (request.getAsyncContext() == null) {
            Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
            if (t != null) {
                this.throwable(request, response, t);
            } else {
                this.status(request, response);
            }
        } else {
            Request.AsyncContextImpl asyncContext = (Request.AsyncContextImpl)request.getAsyncContext();
            if ((event.getType() == HttpEvent.EventType.TIMEOUT || event.getType() == HttpEvent.EventType.ERROR) && request.isEventMode() && asyncContext.getPath() == null) {
                Throwable t = (Throwable)request.getAttribute("javax.servlet.error.exception");
                if (t != null) {
                    this.throwable(request, response, t);
                } else {
                    this.status(request, response);
                }
                if (request.isEventMode() && asyncContext.getPath() == null) {
                    asyncContext.complete();
                }
            }
        }
        if (instances != null && instances.length > 0) {
            for (int i = instances.length - 1; i >= 0; --i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestDestroyed(event2);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerDestroyException(instances[i].getClass().getName()), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                }
            }
        }
        context.getThreadBindingListener().unbind();
        Thread.currentThread().setContextClassLoader(StandardHostValve.class.getClassLoader());
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable realError = throwable;
        if (realError instanceof ServletException && (realError = ((ServletException)realError).getRootCause()) == null) {
            realError = throwable;
        }
        if (realError instanceof ClientAbortException) {
            CatalinaLogger.CORE_LOGGER.clientAbortException(realError.getCause().getMessage());
            return;
        }
        ErrorPage errorPage = StandardHostValve.findErrorPage(context, throwable);
        if (errorPage == null && realError != throwable) {
            errorPage = StandardHostValve.findErrorPage(context, realError);
        }
        if (errorPage != null) {
            response.setAppCommitted(false);
            request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
            request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.ERROR_INTEGER);
            request.setAttribute("javax.servlet.error.status_code", 500);
            request.setAttribute("javax.servlet.error.message", throwable.getMessage());
            request.setAttribute("javax.servlet.error.exception", realError);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            request.setAttribute("javax.servlet.error.exception_type", realError.getClass());
            if (this.custom(request, response, errorPage)) {
                try {
                    response.flushBuffer();
                }
                catch (ClientAbortException e) {
                }
                catch (IOException e) {
                    this.container.getLogger().warn((Object)CatalinaMessages.MESSAGES.errorProcessingErrorPage(errorPage.getLocation()), (Throwable)e);
                }
            }
        } else {
            response.setStatus(500);
            response.setError();
            this.status(request, response);
        }
    }

    protected void status(Request request, Response response) {
        int statusCode = response.getStatus();
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage == null) {
            errorPage = context.findErrorPage(0);
        }
        if (errorPage != null) {
            response.setAppCommitted(false);
            request.setAttribute("javax.servlet.error.status_code", statusCode);
            String message = response.getMessage();
            if (message == null) {
                message = "";
            }
            request.setAttribute("javax.servlet.error.message", message);
            request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
            request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", ApplicationFilterFactory.ERROR_INTEGER);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            if (this.custom(request, response, errorPage)) {
                try {
                    response.flushBuffer();
                }
                catch (ClientAbortException e) {
                }
                catch (IOException e) {
                    this.container.getLogger().warn((Object)CatalinaMessages.MESSAGES.errorProcessingErrorPage(errorPage.getLocation()), (Throwable)e);
                }
            }
        }
    }

    protected static ErrorPage findErrorPage(Context context, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String name = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    protected boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.container.getLogger().isDebugEnabled()) {
            this.container.getLogger().debug((Object)("Processing " + errorPage));
        }
        request.setPathInfo(errorPage.getLocation());
        try {
            response.resetBuffer(true);
            response.setContentLength(-1);
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            rd.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
            response.setSuspended(false);
            return true;
        }
        catch (Throwable t) {
            this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.errorProcessingErrorPage(errorPage.getLocation()), t);
            return false;
        }
    }
}

