/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.service.BundleLifecycleIntegration;
import org.jboss.as.osgi.service.InitialDeploymentTracker;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;

public class BundleInstallProcessor
implements DeploymentUnitProcessor {
    private final InitialDeploymentTracker deploymentTracker;

    public BundleInstallProcessor(InitialDeploymentTracker deploymentTracker) {
        this.deploymentTracker = deploymentTracker;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Deployment deployment = (Deployment)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
        if (deployment == null) {
            return;
        }
        try {
            BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
            BundleContext syscontext = (BundleContext)depUnit.getAttachment(OSGiConstants.SYSTEM_CONTEXT_KEY);
            if (this.deploymentTracker.hasDeploymentName(depUnit.getName())) {
                this.restoreStorageState(phaseContext, deployment);
            }
            XBundleRevision brev = bundleManager.createBundleRevision(syscontext, deployment, phaseContext.getServiceTarget());
            depUnit.putAttachment(OSGiConstants.BUNDLE_REVISION_KEY, (Object)brev);
            depUnit.putAttachment(Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.INSTALLED);
        }
        catch (BundleException ex) {
            throw new DeploymentUnitProcessingException((Throwable)ex);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        if (brev == null) {
            return;
        }
        XBundle bundle2 = brev.getBundle();
        BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
        if (this.uninstallRequired(depUnit, brev)) {
            try {
                int options = this.getUninstallOptions(bundleManager);
                bundleManager.uninstallBundle(bundle2, options);
            }
            catch (BundleException ex) {
                Deployment dep = (Deployment)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
                OSGiLogger.LOGGER.errorFailedToUninstallDeployment(ex, dep);
            }
        } else {
            BundleWiring wiring = brev.getWiringSupport().getWiring(false);
            if (wiring == null || !wiring.isInUse()) {
                bundleManager.removeRevision(brev, 0);
            }
        }
    }

    private void restoreStorageState(DeploymentPhaseContext phaseContext, Deployment deployment) {
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        StorageManager storageProvider = (StorageManager)serviceRegistry.getRequiredService(IntegrationServices.STORAGE_MANAGER_PLUGIN).getValue();
        StorageState storageState = storageProvider.getStorageState(deployment.getLocation());
        if (storageState != null) {
            deployment.setAutoStart(storageState.isPersistentlyStarted());
            deployment.putAttachment(IntegrationConstants.STORAGE_STATE_KEY, (Object)storageState);
        }
    }

    private boolean uninstallRequired(DeploymentUnit depUnit, XBundleRevision brev) {
        Boolean startFailed = (Boolean)depUnit.removeAttachment(OSGiConstants.DEFERRED_ACTIVATION_FAILED);
        if (Boolean.TRUE.equals(startFailed)) {
            return false;
        }
        XBundle bundle2 = brev.getBundle();
        if (bundle2.getState() == 1 || brev.getState() == XResource.State.UNINSTALLED) {
            return false;
        }
        if (bundle2.getBundleRevision() != brev) {
            return false;
        }
        return !BundleLifecycleIntegration.isBundleRefreshing(bundle2);
    }

    private int getUninstallOptions(BundleManager bundleManager) {
        ServiceContainer serviceContainer = bundleManager.getServiceContainer();
        ServiceController controller = serviceContainer.getRequiredService(Services.JBOSS_SERVER_CONTROLLER);
        boolean stopRequested = controller.getSubstate() == ServiceController.Substate.STOP_REQUESTED;
        return stopRequested ? 1 : 0;
    }
}

