/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.osgi.parser.OSGiRootResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public abstract class StartLevelHandler
implements OperationStepHandler {
    public static final StartLevelHandler READ_HANDLER = new StartLevelHandler(){

        @Override
        void invokeOperation(Bundle sysbundle, OperationContext context, ModelNode operation) {
            FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)sysbundle.adapt(FrameworkStartLevel.class);
            int startlevel = frameworkStartLevel.getStartLevel();
            context.getResult().set(startlevel);
        }
    };
    public static final StartLevelHandler WRITE_HANDLER = new StartLevelHandler(){

        @Override
        void invokeOperation(Bundle sysbundle, OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value = operation.require("value");
            OSGiRootResource.STARTLEVEL.getValidator().validateParameter("value", value);
            int startlevel = value.asInt();
            FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)sysbundle.adapt(FrameworkStartLevel.class);
            frameworkStartLevel.setStartLevel(startlevel, new FrameworkListener[0]);
        }
    };

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceController controller = context.getServiceRegistry(false).getService(Services.SYSTEM_BUNDLE);
        if (controller != null && controller.getState() == ServiceController.State.UP) {
            Bundle sysbundle = (Bundle)controller.getValue();
            this.invokeOperation(sysbundle, context, operation);
        } else {
            context.getResult().set(new ModelNode());
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    abstract void invokeOperation(Bundle var1, OperationContext var2, ModelNode var3) throws OperationFailedException;
}

