/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.parser.FrameworkCapabilityResource;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class OSGiCapabilityAdd
extends AbstractAddStepHandler {
    static final OSGiCapabilityAdd INSTANCE = new OSGiCapabilityAdd();

    private OSGiCapabilityAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        FrameworkCapabilityResource.STARTLEVEL.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Integer startLevel = operation.hasDefined("startlevel") ? Integer.valueOf(FrameworkCapabilityResource.STARTLEVEL.resolveModelAttribute(context, model).asInt()) : null;
        String identifier = operation.get("address").asObject().get("capability").asString();
        SubsystemState.OSGiCapability module = new SubsystemState.OSGiCapability(identifier, startLevel);
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.addCapability(module);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String identifier = operation.get("address").asObject().get("capability").asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.removeCapability(identifier);
        }
    }
}

