/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jboss.as.domain.http.server.Common;
import org.jboss.dmr.ModelNode;
import org.xnio.IoUtils;
import org.xnio.streams.ChannelOutputStream;

public class DomainUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(HttpServerExchange exchange, boolean isGet, boolean pretty, ModelNode response, int status, boolean encode) {
        String contentType = encode ? "application/dmr-encoded" : "application/json";
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType + ";" + Common.UTF_8);
        exchange.setResponseCode(status);
        if (isGet && status == 200) {
            response = response.get("result");
        }
        ChannelOutputStream out = new ChannelOutputStream(exchange.getResponseChannel());
        PrintWriter print = new PrintWriter((OutputStream)out);
        try {
            try {
                if (encode) {
                    response.writeBase64((OutputStream)out);
                } else {
                    response.writeJSONString(print, !pretty);
                }
            }
            finally {
                print.flush();
                try {
                    out.flush();
                }
                finally {
                    IoUtils.safeClose((Closeable)print);
                    IoUtils.safeClose((Closeable)out);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String constructUrl(HttpServerExchange exchange, String path) {
        HeaderMap headers = exchange.getRequestHeaders();
        String host = headers.getFirst(Headers.HOST);
        String protocol = exchange.getConnection().getSslSession() != null ? "https" : "http";
        return protocol + "://" + host + path;
    }
}

