/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.Manifest;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.osgi.framework.Bundle;

public final class WebBundleURIParser {
    private WebBundleURIParser() {
    }

    public static Manifest parse(String location) {
        URI uri;
        if (!location.startsWith("webbundle:")) {
            return null;
        }
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException ex) {
            return null;
        }
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        try {
            uri = new URI(schemeSpecificPart);
        }
        catch (URISyntaxException ex) {
            // empty catch block
        }
        String symbolicName = null;
        String contextPath = null;
        String query = uri.getQuery();
        if (query != null) {
            for (String part : query.split("&")) {
                int valueIndex = part.indexOf("=") + 1;
                if (part.startsWith("Bundle-SymbolicName")) {
                    symbolicName = part.substring(valueIndex);
                    continue;
                }
                if (!part.startsWith("Web-ContextPath")) continue;
                contextPath = part.substring(valueIndex);
            }
        }
        if (contextPath == null) {
            contextPath = uri.getHost();
            if (contextPath.endsWith(".war")) {
                contextPath = contextPath.substring(0, contextPath.length() - 4);
            } else {
                int index = contextPath.indexOf(".jar");
                if (index > 0) {
                    contextPath = contextPath.substring(0, index);
                }
            }
        }
        OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
        builder.addBundleManifestVersion(2);
        builder.addBundleSymbolicName(symbolicName);
        builder.addManifestHeader("Web-ContextPath", contextPath);
        builder.addImportPackages(new Class[]{WebServlet.class, Servlet.class, HttpServlet.class});
        builder.addImportPackages(new Class[]{Bundle.class});
        builder.addBundleClasspath("WEB-INF/classes");
        Manifest manifest = builder.getManifest();
        return manifest;
    }
}

