/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.util.Hashtable;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.osgi.httpservice.HttpServiceFactory;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

final class HttpServiceFactoryService
implements Service<WebDeploymentController> {
    static final ServiceName JBOSS_WEB_HTTPSERVICE_FACTORY = CommonWebServer.SERVICE_NAME.append(new String[]{"httpservice", "factory"});
    static final String VIRTUAL_HOST = "default-host";
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<PathManager> injectedPathManager = new InjectedValue();
    private final InjectedValue<WebHost> injectedVirtualHost = new InjectedValue();
    private final InjectedValue<HttpManagement> injectedHttpManagement = new InjectedValue();
    private final InjectedValue<CommonWebServer> injectedWebServer = new InjectedValue();
    private ServiceRegistration registration;

    private HttpServiceFactoryService() {
    }

    static ServiceController<WebDeploymentController> addService(ServiceTarget serviceTarget) {
        HttpServiceFactoryService service = new HttpServiceFactoryService();
        ServiceBuilder builder = serviceTarget.addService(JBOSS_WEB_HTTPSERVICE_FACTORY, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.injectedPathManager);
        builder.addDependency(WebHost.SERVICE_NAME.append(new String[]{VIRTUAL_HOST}), WebHost.class, service.injectedVirtualHost);
        builder.addDependency(CommonWebServer.SERVICE_NAME, CommonWebServer.class, service.injectedWebServer);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, UndertowHttpManagementService.SERVICE_NAME, HttpManagement.class, service.injectedHttpManagement);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, service.injectedSystemContext);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
        WebHost virtualHost = (WebHost)this.injectedVirtualHost.getValue();
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        CommonWebServer webServer = (CommonWebServer)this.injectedWebServer.getValue();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("provider", this.getClass().getPackage().getName());
        HttpServiceFactory serviceFactory = new HttpServiceFactory(webServer, virtualHost, serverEnvironment);
        this.registration = syscontext.registerService(HttpService.class.getName(), (Object)serviceFactory, props);
    }

    public void stop(StopContext stopContext) {
        this.registration.unregister();
    }

    public WebDeploymentController getValue() throws IllegalStateException {
        return null;
    }
}

