/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class ClassUtil {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    private ClassUtil() {
    }

    static boolean isClassAssignable(Class<?> from, Class<?> to) {
        if (from == null) {
            throw new IllegalArgumentException("from is null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to is null");
        }
        return to.isAssignableFrom(from);
    }

    static boolean modifiersHasSynchronizedKeyword(int modifiers) {
        return Modifier.isSynchronized(modifiers);
    }

    static Method getClassMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException("Class is null");
        }
        if (methodName == null || methodName.equals("")) {
            throw new IllegalArgumentException("Method name is null or empty");
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_ARRAY;
        }
        return clazz.getMethod(methodName, parameterTypes);
    }
}

