/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;

public class TransactionManagementMergingProcessor
extends AbstractMergingProcessor<EJBComponentDescription> {
    public TransactionManagementMergingProcessor() {
        super(EJBComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation management = clazz.getAnnotationInformation(TransactionManagement.class);
        if (management == null) {
            return;
        }
        if (!management.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setTransactionManagementType((TransactionManagementType)management.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, EJBComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EnterpriseBeanMetaData beanMetaData = componentConfiguration.getDescriptorData();
        if (componentConfiguration.isEntity() || beanMetaData == null) {
            return;
        }
        TransactionManagementType type = componentConfiguration.getDescriptorData().getTransactionType();
        if (type != null) {
            componentConfiguration.setTransactionManagementType(type);
        }
    }
}

