/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.net.InetAddress;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StabilityStatistics;

public final class BootstrapListener {
    private final StabilityMonitor monitor = new StabilityMonitor();
    private final ServiceContainer serviceContainer;
    private final ServiceTarget serviceTarget;
    private final long startTime;
    private final String prettyVersion;
    private final FutureServiceContainer futureContainer;

    public BootstrapListener(ServiceContainer serviceContainer, long startTime, ServiceTarget serviceTarget, FutureServiceContainer futureContainer, String prettyVersion) {
        this.serviceContainer = serviceContainer;
        this.startTime = startTime;
        this.serviceTarget = serviceTarget;
        this.prettyVersion = prettyVersion;
        this.futureContainer = futureContainer;
        serviceTarget.addMonitor(this.monitor);
    }

    public StabilityMonitor getStabilityMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBootStatistics() {
        StabilityStatistics statistics = new StabilityStatistics();
        try {
            this.monitor.awaitStability(statistics);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.serviceTarget.removeMonitor(this.monitor);
            long bootstrapTime = System.currentTimeMillis() - this.startTime;
            this.done(bootstrapTime, statistics);
            this.monitor.clear();
        }
    }

    protected void done(long bootstrapTime, StabilityStatistics statistics) {
        this.futureContainer.done(this.serviceContainer);
        if (this.serviceContainer.isShutdown()) {
            return;
        }
        this.logAdminConsole();
        int active = statistics.getActiveCount();
        int failed = statistics.getFailedCount();
        int lazy = statistics.getLazyCount();
        int never = statistics.getNeverCount();
        int onDemand = statistics.getOnDemandCount();
        int passive = statistics.getPassiveCount();
        int problem = statistics.getProblemsCount();
        int started = statistics.getStartedCount();
        if (failed == 0 && problem == 0) {
            ServerLogger.AS_ROOT_LOGGER.startedClean(this.prettyVersion, bootstrapTime, started, active + passive + onDemand + never + lazy, onDemand + passive + lazy);
        } else {
            ServerLogger.AS_ROOT_LOGGER.startedWitErrors(this.prettyVersion, bootstrapTime, started, active + passive + onDemand + never + lazy, failed + problem, onDemand + passive + lazy);
        }
    }

    private void logAdminConsole() {
        ServiceController controller = this.serviceContainer.getService(UndertowHttpManagementService.SERVICE_NAME);
        if (controller != null) {
            boolean hasHttps;
            HttpManagement mgmt = (HttpManagement)controller.getValue();
            boolean hasHttp = mgmt.getHttpNetworkInterfaceBinding() != null && mgmt.getHttpPort() > 0;
            boolean bl = hasHttps = mgmt.getHttpsNetworkInterfaceBinding() != null && mgmt.getHttpsPort() > 0;
            if (hasHttp && hasHttps) {
                ServerLogger.AS_ROOT_LOGGER.logHttpAndHttpsManagement(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort(), NetworkUtils.formatAddress((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                if (mgmt.hasConsole()) {
                    ServerLogger.AS_ROOT_LOGGER.logHttpAndHttpsConsole(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort(), NetworkUtils.formatAddress((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                } else {
                    ServerLogger.AS_ROOT_LOGGER.logNoConsole();
                }
            } else if (hasHttp) {
                ServerLogger.AS_ROOT_LOGGER.logHttpManagement(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort());
                if (mgmt.hasConsole()) {
                    ServerLogger.AS_ROOT_LOGGER.logHttpConsole(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpNetworkInterfaceBinding().getAddress()), mgmt.getHttpPort());
                } else {
                    ServerLogger.AS_ROOT_LOGGER.logNoConsole();
                }
            } else if (hasHttps) {
                ServerLogger.AS_ROOT_LOGGER.logHttpsManagement(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                if (mgmt.hasConsole()) {
                    ServerLogger.AS_ROOT_LOGGER.logHttpsConsole(NetworkUtils.formatAddress((InetAddress)mgmt.getHttpsNetworkInterfaceBinding().getAddress()), mgmt.getHttpsPort());
                } else {
                    ServerLogger.AS_ROOT_LOGGER.logNoConsole();
                }
            } else {
                ServerLogger.AS_ROOT_LOGGER.logNoHttpManagement();
                ServerLogger.AS_ROOT_LOGGER.logNoConsole();
            }
        }
    }
}

