/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.TypeValidator;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class UnionTypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnionTypeValidator.class);
    private final List<JsonValidator> schemas = new ArrayList<JsonValidator>();
    private final String error;

    public UnionTypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNION_TYPE, validationContext);
        this.validationContext = validationContext;
        StringBuilder errorBuilder = new StringBuilder();
        String sep = "";
        errorBuilder.append('[');
        if (!schemaNode.isArray()) {
            throw new JsonSchemaException("Expected array for type property on Union Type Definition.");
        }
        int i = 0;
        for (JsonNode n : schemaNode) {
            JsonType t2 = TypeFactory.getSchemaNodeType(n);
            errorBuilder.append(sep).append((Object)t2);
            sep = ", ";
            if (n.isObject()) {
                this.schemas.add(validationContext.newSchema(ValidatorTypeCode.TYPE.getValue(), n, parentSchema));
            } else {
                this.schemas.add(new TypeValidator(schemaPath + "/" + i, n, parentSchema, validationContext));
            }
            ++i;
        }
        errorBuilder.append(']');
        this.error = errorBuilder.toString();
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        UnionTypeValidator.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        boolean valid = false;
        for (JsonValidator schema : this.schemas) {
            Set<ValidationMessage> errors = schema.validate(node, rootNode, at);
            if (errors != null && !errors.isEmpty()) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return Collections.singleton(this.buildValidationMessage(at, nodeType.toString(), this.error));
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonValidator validator : this.schemas) {
            validator.preloadJsonSchema();
        }
    }
}

