/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.http.Body;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;

public class RequestPartTemplateModel {
    private final String name;
    private final Map<String, ListOrSingle<String>> headers;
    private final Body body;

    public RequestPartTemplateModel(String name, Map<String, ListOrSingle<String>> headers, Body body) {
        this.name = name;
        this.headers = new TreeMap<String, ListOrSingle<String>>(String.CASE_INSENSITIVE_ORDER);
        this.headers.putAll(headers);
        this.body = body;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ListOrSingle<String>> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body.asString();
    }

    public String getBodyAsBase64() {
        return this.body.asBase64();
    }

    public boolean isBinary() {
        return this.body.isBinary();
    }

    public String toString() {
        return new StringJoiner(", ", "[", "]").add("name='" + this.name + "'").add("headers=" + String.valueOf(this.headers)).add("body=" + this.body.asString()).toString();
    }
}

