/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.serialization.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ArrayNode;
import wiremock.com.fasterxml.jackson.databind.node.BinaryNode;
import wiremock.com.fasterxml.jackson.databind.node.BooleanNode;
import wiremock.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import wiremock.com.fasterxml.jackson.databind.node.NullNode;
import wiremock.com.fasterxml.jackson.databind.node.NumericNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.fasterxml.jackson.databind.node.TextNode;
import wiremock.com.fasterxml.jackson.databind.node.ValueNode;
import wiremock.com.fasterxml.jackson.databind.util.RawValue;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareArrayNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareBigIntegerNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareBinaryNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareBooleanNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareDecimalNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareDoubleNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareFloatNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareIntNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareLongNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareNullNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareObjectNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwarePOJONode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareShortNode;
import wiremock.com.networknt.schema.serialization.node.JsonLocationAwareTextNode;

public class LocationJsonNodeFactory
extends JsonNodeFactory {
    private static final long serialVersionUID = 1L;
    private final JsonParser jsonParser;

    public LocationJsonNodeFactory(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    @Override
    public BooleanNode booleanNode(boolean v) {
        return new JsonLocationAwareBooleanNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public NullNode nullNode() {
        return new JsonLocationAwareNullNode(this.jsonParser.currentTokenLocation());
    }

    @Override
    public JsonNode missingNode() {
        return super.missingNode();
    }

    @Override
    public NumericNode numberNode(byte v) {
        return new JsonLocationAwareIntNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode numberNode(Byte v) {
        return v == null ? this.nullNode() : this.numberNode(v.intValue());
    }

    @Override
    public NumericNode numberNode(short v) {
        return new JsonLocationAwareShortNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode numberNode(Short value) {
        return value == null ? this.nullNode() : this.numberNode((short)value);
    }

    @Override
    public NumericNode numberNode(int v) {
        return new JsonLocationAwareIntNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode numberNode(Integer v) {
        return v == null ? this.nullNode() : this.numberNode((int)v);
    }

    @Override
    public NumericNode numberNode(long v) {
        return new JsonLocationAwareLongNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode numberNode(Long v) {
        return v == null ? this.nullNode() : this.numberNode((long)v);
    }

    @Override
    public ValueNode numberNode(BigInteger v) {
        return v == null ? this.nullNode() : new JsonLocationAwareBigIntegerNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public NumericNode numberNode(float v) {
        return new JsonLocationAwareFloatNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode numberNode(Float v) {
        return v == null ? this.nullNode() : this.numberNode(v.floatValue());
    }

    @Override
    public NumericNode numberNode(double v) {
        return new JsonLocationAwareDoubleNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode numberNode(Double v) {
        return v == null ? this.nullNode() : this.numberNode((double)v);
    }

    @Override
    public ValueNode numberNode(BigDecimal v) {
        return v == null ? this.nullNode() : new JsonLocationAwareDecimalNode(v, this.jsonParser.currentTokenLocation());
    }

    @Override
    public TextNode textNode(String text) {
        return new JsonLocationAwareTextNode(text, this.jsonParser.currentTokenLocation());
    }

    @Override
    public BinaryNode binaryNode(byte[] data) {
        return new JsonLocationAwareBinaryNode(data, this.jsonParser.currentTokenLocation());
    }

    @Override
    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return new JsonLocationAwareBinaryNode(data, offset, length, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ArrayNode arrayNode() {
        return new JsonLocationAwareArrayNode((JsonNodeFactory)this, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ArrayNode arrayNode(int capacity) {
        return new JsonLocationAwareArrayNode((JsonNodeFactory)this, capacity, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ObjectNode objectNode() {
        return new JsonLocationAwareObjectNode((JsonNodeFactory)this, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode pojoNode(Object pojo) {
        return new JsonLocationAwarePOJONode(pojo, this.jsonParser.currentTokenLocation());
    }

    @Override
    public ValueNode rawValueNode(RawValue value) {
        return new JsonLocationAwarePOJONode(value, this.jsonParser.currentTokenLocation());
    }
}

