/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorState;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.com.networknt.schema.regex.RegularExpression;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class AdditionalPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AdditionalPropertiesValidator.class);
    private final boolean allowAdditionalProperties;
    private final JsonSchema additionalPropertiesSchema;
    private final Set<String> allowedProperties;
    private final List<RegularExpression> patternProperties = new ArrayList<RegularExpression>();
    private Boolean hasUnevaluatedPropertiesValidator;

    public AdditionalPropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ADDITIONAL_PROPERTIES, validationContext);
        JsonNode patternPropertiesNode;
        if (schemaNode.isBoolean()) {
            this.allowAdditionalProperties = schemaNode.booleanValue();
            this.additionalPropertiesSchema = null;
        } else if (schemaNode.isObject()) {
            this.allowAdditionalProperties = true;
            this.additionalPropertiesSchema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
        } else {
            this.allowAdditionalProperties = false;
            this.additionalPropertiesSchema = null;
        }
        JsonNode propertiesNode = parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null) {
            this.allowedProperties = new HashSet<String>();
            Iterator<String> it = propertiesNode.fieldNames();
            while (it.hasNext()) {
                this.allowedProperties.add(it.next());
            }
        } else {
            this.allowedProperties = Collections.emptySet();
        }
        if ((patternPropertiesNode = parentSchema.getSchemaNode().get("patternProperties")) != null) {
            Iterator<String> it = patternPropertiesNode.fieldNames();
            while (it.hasNext()) {
                this.patternProperties.add(RegularExpression.compile(it.next(), validationContext));
            }
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        boolean collectAnnotations;
        AdditionalPropertiesValidator.debug(logger, node, rootNode, instanceLocation);
        if (!node.isObject()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> matchedInstancePropertyNames = null;
        boolean bl = collectAnnotations = this.collectAnnotations() || this.collectAnnotations(executionContext);
        if (this.allowAdditionalProperties && collectAnnotations) {
            Iterator<String> it = node.fieldNames();
            while (it.hasNext()) {
                if (matchedInstancePropertyNames == null) {
                    matchedInstancePropertyNames = new LinkedHashSet<String>();
                }
                String fieldName = it.next();
                matchedInstancePropertyNames.add(fieldName);
            }
        }
        LinkedHashSet<ValidationMessage> errors = null;
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            Set<ValidationMessage> results;
            String pname = it.next();
            if (pname.startsWith("#")) continue;
            boolean handledByPatternProperties = false;
            for (RegularExpression pattern : this.patternProperties) {
                if (!pattern.matches(pname)) continue;
                handledByPatternProperties = true;
                break;
            }
            if (this.allowedProperties.contains(pname) || handledByPatternProperties) continue;
            if (!this.allowAdditionalProperties) {
                if (errors == null) {
                    errors = new LinkedHashSet<ValidationMessage>();
                }
                errors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).property(pname)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(pname)).build());
                continue;
            }
            if (this.additionalPropertiesSchema == null) continue;
            ValidatorState state = executionContext.getValidatorState();
            if (state != null && state.isWalkEnabled()) {
                results = this.additionalPropertiesSchema.walk(executionContext, node.get(pname), rootNode, instanceLocation.append(pname), state.isValidationEnabled());
                if (results.isEmpty()) continue;
                if (errors == null) {
                    errors = new LinkedHashSet();
                }
                errors.addAll(results);
                continue;
            }
            results = this.additionalPropertiesSchema.validate(executionContext, node.get(pname), rootNode, instanceLocation.append(pname));
            if (results.isEmpty()) continue;
            if (errors == null) {
                errors = new LinkedHashSet();
            }
            errors.addAll(results);
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames != null ? matchedInstancePropertyNames : Collections.emptySet()).build());
        }
        return errors == null ? Collections.emptySet() : Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, instanceLocation);
        }
        if (node == null || !node.isObject()) {
            return Collections.emptySet();
        }
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            ValidatorState state;
            String pname = it.next();
            if (pname.startsWith("#")) continue;
            boolean handledByPatternProperties = false;
            for (RegularExpression pattern : this.patternProperties) {
                if (!pattern.matches(pname)) continue;
                handledByPatternProperties = true;
                break;
            }
            if (this.allowedProperties.contains(pname) || handledByPatternProperties || !this.allowAdditionalProperties || this.additionalPropertiesSchema == null || (state = executionContext.getValidatorState()) == null || !state.isWalkEnabled()) continue;
            this.additionalPropertiesSchema.walk(executionContext, node.get(pname), rootNode, instanceLocation.append(pname), state.isValidationEnabled());
        }
        return Collections.emptySet();
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedPropertiesValidator();
    }

    private boolean hasUnevaluatedPropertiesValidator() {
        if (this.hasUnevaluatedPropertiesValidator == null) {
            this.hasUnevaluatedPropertiesValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedProperties");
        }
        return this.hasUnevaluatedPropertiesValidator;
    }

    @Override
    public void preloadJsonSchema() {
        if (this.additionalPropertiesSchema != null) {
            this.additionalPropertiesSchema.initializeValidators();
        }
        this.collectAnnotations();
    }
}

