/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CachedSupplier;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.InvalidSchemaRefException;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaFactory;
import wiremock.com.networknt.schema.JsonSchemaRef;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchemaRef schema;
    private static final String REF_CURRENT = "#";

    public RefValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue, JsonNodePath evaluationPath) {
        String refValueOriginal = refValue;
        if (!refValue.startsWith(REF_CURRENT)) {
            int index = refValue.indexOf(REF_CURRENT);
            String refUri = index > 0 ? refValue.substring(0, index) : refValue;
            String schemaUriFinal = RefValidator.resolve(parentSchema, refUri);
            SchemaLocation schemaLocation = SchemaLocation.of(schemaUriFinal);
            return new JsonSchemaRef(new CachedSupplier<JsonSchema>(() -> {
                JsonSchema schemaResource = (JsonSchema)validationContext.getSchemaResources().get(schemaUriFinal);
                if (schemaResource == null && (schemaResource = validationContext.getJsonSchemaFactory().getSchema(schemaLocation, validationContext.getConfig())) != null) {
                    RefValidator.copySchemaResources(validationContext, schemaResource);
                }
                if (index < 0) {
                    if (schemaResource == null) {
                        return null;
                    }
                    return schemaResource.fromRef(parentSchema, evaluationPath);
                }
                String newRefValue = refValue.substring(index);
                String find = schemaLocation.getAbsoluteIri() + newRefValue;
                JsonSchema findSchemaResource = (JsonSchema)validationContext.getSchemaResources().get(find);
                if (findSchemaResource == null) {
                    findSchemaResource = (JsonSchema)validationContext.getDynamicAnchors().get(find);
                }
                if ((schemaResource = findSchemaResource != null ? findSchemaResource : RefValidator.getJsonSchema(schemaResource, validationContext, newRefValue, refValueOriginal, evaluationPath)) == null) {
                    return null;
                }
                return schemaResource.fromRef(parentSchema, evaluationPath);
            }));
        }
        if (SchemaLocation.Fragment.isAnchorFragment(refValue)) {
            String absoluteIri = RefValidator.resolve(parentSchema, refValue);
            return new JsonSchemaRef(new CachedSupplier<JsonSchema>(() -> {
                JsonSchema schemaResource = (JsonSchema)validationContext.getSchemaResources().get(absoluteIri);
                if (schemaResource == null) {
                    schemaResource = (JsonSchema)validationContext.getDynamicAnchors().get(absoluteIri);
                }
                if (schemaResource == null) {
                    schemaResource = RefValidator.getJsonSchema(parentSchema, validationContext, refValue, refValueOriginal, evaluationPath);
                }
                if (schemaResource == null) {
                    return null;
                }
                return schemaResource.fromRef(parentSchema, evaluationPath);
            }));
        }
        if (refValue.equals(REF_CURRENT)) {
            return new JsonSchemaRef(new CachedSupplier<JsonSchema>(() -> parentSchema.findSchemaResourceRoot().fromRef(parentSchema, evaluationPath)));
        }
        return new JsonSchemaRef(new CachedSupplier<JsonSchema>(() -> RefValidator.getJsonSchema(parentSchema, validationContext, refValue, refValueOriginal, evaluationPath).fromRef(parentSchema, evaluationPath)));
    }

    private static void copySchemaResources(ValidationContext validationContext, JsonSchema schemaResource) {
        if (!schemaResource.getValidationContext().getSchemaResources().isEmpty()) {
            validationContext.getSchemaResources().putAll(schemaResource.getValidationContext().getSchemaResources());
        }
        if (!schemaResource.getValidationContext().getSchemaReferences().isEmpty()) {
            validationContext.getSchemaReferences().putAll(schemaResource.getValidationContext().getSchemaReferences());
        }
        if (!schemaResource.getValidationContext().getDynamicAnchors().isEmpty()) {
            validationContext.getDynamicAnchors().putAll(schemaResource.getValidationContext().getDynamicAnchors());
        }
    }

    private static String resolve(JsonSchema parentSchema, String refValue) {
        JsonSchema base = parentSchema;
        if (parentSchema.getId() != null && parentSchema.parentSchema != null) {
            base = parentSchema.parentSchema;
        }
        return SchemaLocation.resolve(base.getSchemaLocation(), refValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonSchema getJsonSchema(JsonSchema parent, ValidationContext validationContext, String refValue, String refValueOriginal, JsonNodePath evaluationPath) {
        JsonNodePath fragment = SchemaLocation.Fragment.of(refValue);
        String schemaReference = RefValidator.resolve(parent, refValueOriginal);
        JsonSchema result = (JsonSchema)validationContext.getSchemaReferences().get(schemaReference);
        if (result == null) {
            JsonSchemaFactory jsonSchemaFactory = validationContext.getJsonSchemaFactory();
            synchronized (jsonSchemaFactory) {
                result = (JsonSchema)validationContext.getSchemaReferences().get(schemaReference);
                if (result == null && (result = parent.getSubSchema(fragment)) != null) {
                    validationContext.getSchemaReferences().put(schemaReference, result);
                }
            }
        }
        return result;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        RefValidator.debug(logger, node, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        return refSchema.validate(executionContext, node, rootNode, instanceLocation);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        RefValidator.debug(logger, node, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        return refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        JsonSchema jsonSchema = null;
        try {
            jsonSchema = this.schema.getSchema();
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JsonSchemaException(e);
        }
        SchemaLocation schemaLocation = jsonSchema.getSchemaLocation();
        JsonSchema check = jsonSchema;
        boolean circularDependency = false;
        while (check.getEvaluationParentSchema() != null) {
            if (!(check = check.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
            circularDependency = true;
            break;
        }
        if (!circularDependency) {
            jsonSchema.initializeValidators();
        }
    }
}

