/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.http.NetworkAddressRulesAdheringDnsResolver;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ssl.HostVerifyingSSLSocketFactory;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.TrustEverythingStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSelfSignedStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustSpecificHostsStrategy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import wiremock.org.apache.hc.client5.http.auth.AuthScope;
import wiremock.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpDelete;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpGet;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpHead;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpOptions;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpPatch;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpPost;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpPut;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpTrace;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import wiremock.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import wiremock.org.apache.hc.client5.http.config.RequestConfig;
import wiremock.org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import wiremock.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import wiremock.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import wiremock.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import wiremock.org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import wiremock.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import wiremock.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import wiremock.org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import wiremock.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import wiremock.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.config.CharCodingConfig;
import wiremock.org.apache.hc.core5.util.TextUtils;
import wiremock.org.apache.hc.core5.util.TimeValue;
import wiremock.org.apache.hc.core5.util.Timeout;

public class HttpClientFactory {
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final int DEFAULT_TIMEOUT = 30000;

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse) {
        NetworkAddressRulesAdheringDnsResolver dnsResolver = new NetworkAddressRulesAdheringDnsResolver(networkAddressRules);
        HttpClientBuilder builder = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().disableContentCompression().setConnectionManager(PoolingHttpClientConnectionManagerBuilder.create().setDnsResolver(dnsResolver).setMaxConnPerRoute(maxConnections).setMaxConnTotal(maxConnections).setValidateAfterInactivity(TimeValue.ofSeconds(5L)).setConnectionFactory(new ManagedHttpClientConnectionFactory(null, CharCodingConfig.custom().setCharset(StandardCharsets.UTF_8).build(), null)).build()).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds(timeoutMilliseconds)).build());
        if (disableConnectionReuse) {
            builder.setConnectionReuseStrategy((request, response, context) -> false).setKeepAliveStrategy((response, context) -> TimeValue.ZERO_MILLISECONDS);
        }
        if (useSystemProperties) {
            builder.useSystemProperties();
        }
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            builder.setProxy(proxyHost);
            if (Strings.isNotEmpty(proxySettings.getUsername()) && Strings.isNotEmpty(proxySettings.getPassword())) {
                builder.setProxyAuthenticationStrategy(new DefaultAuthenticationStrategy());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxySettings.host(), proxySettings.port()), new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword().toCharArray()));
                builder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        SSLContext sslContext = HttpClientFactory.buildSslContext(trustStoreSettings, trustAllCertificates, trustedHosts);
        LayeredConnectionSocketFactory sslSocketFactory = HttpClientFactory.buildSslConnectionSocketFactory(sslContext);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(sslSocketFactory).setDnsResolver(dnsResolver).build();
        builder.setConnectionManager(connectionManager);
        return builder.build();
    }

    private static LayeredConnectionSocketFactory buildSslConnectionSocketFactory(SSLContext sslContext) {
        String[] supportedProtocols = HttpClientFactory.split(System.getProperty("https.protocols"));
        String[] supportedCipherSuites = HttpClientFactory.split(System.getProperty("https.cipherSuites"));
        return new SSLConnectionSocketFactory(new HostVerifyingSSLSocketFactory(sslContext.getSocketFactory()), supportedProtocols, supportedCipherSuites, (HostnameVerifier)new NoopHostnameVerifier());
    }

    private static String[] split(String s2) {
        if (TextUtils.isBlank(s2)) {
            return null;
        }
        return s2.split(" *, *");
    }

    private static SSLContext buildSslContext(KeyStoreSettings trustStoreSettings, boolean trustAllCertificates, List<String> trustedHosts) {
        if (trustStoreSettings != KeyStoreSettings.NO_STORE) {
            return HttpClientFactory.buildSSLContextWithTrustStore(trustStoreSettings, trustAllCertificates, trustedHosts);
        }
        if (trustAllCertificates) {
            return HttpClientFactory.buildAllowAnythingSSLContext();
        }
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts)).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean useSystemProperties, NetworkAddressRules networkAddressRules, boolean disableConnectionReuse) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, proxySettings, trustStoreSettings, true, Collections.emptyList(), useSystemProperties, networkAddressRules, disableConnectionReuse);
    }

    private static SSLContext buildSSLContextWithTrustStore(KeyStoreSettings trustStoreSettings, boolean trustSelfSignedCertificates, List<String> trustedHosts) {
        try {
            KeyStore trustStore = trustStoreSettings.loadStore();
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().loadKeyMaterial(trustStore, trustStoreSettings.password().toCharArray());
            if (trustSelfSignedCertificates) {
                sslContextBuilder.loadTrustMaterial(new TrustSelfSignedStrategy());
            } else if (HttpClientFactory.containsCertificate(trustStore)) {
                sslContextBuilder.loadTrustMaterial(trustStore, new TrustSpecificHostsStrategy(trustedHosts));
            } else {
                sslContextBuilder.loadTrustMaterial(new TrustSpecificHostsStrategy(trustedHosts));
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, SSLContext.class);
        }
    }

    private static boolean containsCertificate(KeyStore trustStore) throws KeyStoreException {
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                if (!(trustStore.getEntry(alias, null) instanceof KeyStore.TrustedCertificateEntry)) continue;
                return true;
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException generalSecurityException) {
            }
        }
        return false;
    }

    private static SSLContext buildAllowAnythingSSLContext() {
        try {
            return SSLContextBuilder.create().loadTrustMaterial(new TrustEverythingStrategy()).build();
        }
        catch (Exception e) {
            return (SSLContext)Exceptions.throwUnchecked(e, null);
        }
    }

    public static CloseableHttpClient createClient(int maxConnections, int timeoutMilliseconds) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE, true, NetworkAddressRules.ALLOW_ALL, false);
    }

    public static CloseableHttpClient createClient(int timeoutMilliseconds) {
        return HttpClientFactory.createClient(50, timeoutMilliseconds);
    }

    public static CloseableHttpClient createClient(ProxySettings proxySettings) {
        return HttpClientFactory.createClient(50, 30000, proxySettings, KeyStoreSettings.NO_STORE, true, NetworkAddressRules.ALLOW_ALL, false);
    }

    public static CloseableHttpClient createClient() {
        return HttpClientFactory.createClient(30000);
    }

    public static HttpUriRequest getHttpRequestFor(RequestMethod method, String url) {
        LocalNotifier.notifier().info("Proxying: " + method + " " + url);
        if (method.equals(RequestMethod.GET)) {
            return new HttpGet(url);
        }
        if (method.equals(RequestMethod.POST)) {
            return new HttpPost(url);
        }
        if (method.equals(RequestMethod.PUT)) {
            return new HttpPut(url);
        }
        if (method.equals(RequestMethod.DELETE)) {
            return new HttpDelete(url);
        }
        if (method.equals(RequestMethod.HEAD)) {
            return new HttpHead(url);
        }
        if (method.equals(RequestMethod.OPTIONS)) {
            return new HttpOptions(url);
        }
        if (method.equals(RequestMethod.TRACE)) {
            return new HttpTrace(url);
        }
        if (method.equals(RequestMethod.PATCH)) {
            return new HttpPatch(url);
        }
        return new HttpUriRequestBase(method.toString(), URI.create(url));
    }
}

