/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkAddressUtils {
    private NetworkAddressUtils() {
    }

    public static boolean isValidInet4Address(String ip) {
        try {
            return InetAddress.getByName(ip).getHostAddress().equals(ip);
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    public static long ipToLong(InetAddress ipAddress) {
        byte[] ipAddressOctets;
        long resultIP = 0L;
        for (byte octet : ipAddressOctets = ipAddress.getAddress()) {
            resultIP <<= 8;
            resultIP |= (long)(octet & 0xFF);
        }
        return resultIP;
    }
}

